/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.watcher;

import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public final class MailAccessDelayElement
implements Delayed {
    private static final int WATCHER_TIME = MailProperties.getInstance().getWatcherTime();
    public final MailAccess<?, ?> mailAccess;
    public final long stamp;

    public MailAccessDelayElement(MailAccess<?, ?> mailAccess, long stamp) {
        this.mailAccess = mailAccess;
        this.stamp = stamp;
    }

    @Override
    public int compareTo(Delayed o) {
        long thisStamp = this.stamp;
        long otherStamp = ((MailAccessDelayElement)o).stamp;
        return thisStamp < otherStamp ? -1 : (thisStamp == otherStamp ? 0 : 1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert((long)WATCHER_TIME - (System.currentTimeMillis() - this.stamp), TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        return this.mailAccess.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MailAccessDelayElement)) {
            return false;
        }
        MailAccessDelayElement other = (MailAccessDelayElement)obj;
        return !(this.mailAccess == null ? other.mailAccess != null : !this.mailAccess.equals(other.mailAccess));
    }
}

