/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.uuencode;

import com.openexchange.java.Strings;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUEncodedMultiPart {
    private static final Logger LOG = LoggerFactory.getLogger(UUEncodedMultiPart.class);
    private final List<UUEncodedPart> uuencodeParts = new ArrayList<UUEncodedPart>();
    private StringBuilder text;
    private int count = -1;
    private static final Pattern PAT_UUENCODED = Pattern.compile("(^begin |\r?\nbegin )([0-7]{3} )(\\S[\\p{Alnum}\\p{Punct} \t]*\r?\n)(.+?)(\r?\n[ \t]*`?[ \t]*\r?\nend)", 32);

    public UUEncodedMultiPart() {
    }

    public UUEncodedMultiPart(String content) {
        this();
        this.setContent(content);
    }

    private final void setContent(String content) {
        UUEncodedPart uuencodedPart;
        this.findUUEncodedAttachmentCount(content);
        this.count = this.uuencodeParts.size();
        if (this.count >= 1 && (uuencodedPart = this.uuencodeParts.get(0)).getIndexStart() != -1) {
            this.text = new StringBuilder(content.substring(0, uuencodedPart.getIndexStart()));
        }
    }

    public boolean isUUEncoded() {
        return this.count >= 1;
    }

    public static boolean isUUEncoded(String content) {
        return PAT_UUENCODED.matcher(content).find();
    }

    private final void findUUEncodedAttachmentCount(String sBodyPart) {
        Matcher m = PAT_UUENCODED.matcher(sBodyPart);
        while (m.find()) {
            try {
                int skip = UUEncodedMultiPart.examineBeginToken(m.group(1));
                this.uuencodeParts.add(new UUEncodedPart(m.start(1) + skip, m.start(5), m.group().substring(skip), UUEncodedMultiPart.cleanAtom(m.group(3))));
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
                break;
            }
        }
    }

    private static final int examineBeginToken(String beginToken) {
        int count = 0;
        char c = beginToken.charAt(count);
        while (Strings.isWhitespace((char)c)) {
            c = beginToken.charAt(++count);
        }
        return count;
    }

    private static final String cleanAtom(String atom) {
        return atom.replaceAll("\r?\n", "");
    }

    public String getCleanText() {
        return this.text.toString();
    }

    public int getCount() {
        return this.count;
    }

    public UUEncodedPart getBodyPart(int index) {
        return this.uuencodeParts.get(index);
    }

    public void removeBodyPart(int index) {
        this.uuencodeParts.remove(index);
    }
}

