/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.api.AbstractProtocolProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.InfostoreDocumentMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.session.Session;
import java.util.Map;

public abstract class TransportProvider {
    private final int hashCode = this.getProtocol().hashCode();
    private boolean deprecated;

    protected TransportProvider() {
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportProvider)) {
            return false;
        }
        TransportProvider other = (TransportProvider)obj;
        return !(this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    protected void startUp() throws OXException {
        this.getProtocolProperties().loadProperties();
    }

    protected void shutDown() throws OXException {
        this.getProtocolProperties().resetProperties();
    }

    public abstract Protocol getProtocol();

    public final boolean supportsProtocol(String protocol) {
        return this.getProtocol().isSupported(protocol);
    }

    public abstract MailTransport createNewMailTransport(Session var1) throws OXException;

    public abstract MailTransport createNewMailTransport(Session var1, int var2) throws OXException;

    public abstract MailTransport createNewNoReplyTransport(int var1) throws OXException;

    protected abstract AbstractProtocolProperties getProtocolProperties();

    public abstract ComposedMailMessage getNewComposedMailMessage(Session var1, Context var2) throws OXException;

    public abstract UploadFileMailPart getNewFilePart(UploadFile var1) throws OXException;

    public abstract InfostoreDocumentMailPart getNewDocumentPart(String var1, Session var2) throws OXException;

    public abstract DataMailPart getNewDataPart(Object var1, Map<String, String> var2, Session var3) throws OXException;

    public abstract TextBodyMailPart getNewTextBodyPart(String var1) throws OXException;

    public abstract ReferencedMailPart getNewReferencedPart(MailPart var1, Session var2) throws OXException;

    public abstract ReferencedMailPart getNewReferencedMail(MailMessage var1, Session var2) throws OXException;
}

