/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.TNEFBodyPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeRawSource;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.tools.tnef.TNEF2ICal;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.CompressedRTFInputStream;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextPartFinder {
    private static final Logger LOG = LoggerFactory.getLogger(TextPartFinder.class);
    private static final TextPartFinder INSTANCE = new TextPartFinder();
    private static final String TNEF_IPM_CONTACT = "IPM.Contact";
    private static final String TNEF_IPM_MS_READ_RECEIPT = "IPM.Microsoft Mail.Read Receipt";

    public static TextPartFinder getInstance() {
        return INSTANCE;
    }

    private TextPartFinder() {
    }

    public MailPart getText(MailPart p) throws OXException {
        return this.getTextRecursive(p);
    }

    private MailPart getTextRecursive(MailPart part) throws OXException {
        if (null == part) {
            return null;
        }
        try {
            ContentType ct = part.getContentType();
            if (ct.startsWith("text/")) {
                UUEncodedMultiPart uuencodedMP;
                MailPart textPart = part;
                String content = TextPartFinder.readContent(part, ct);
                if (ct.startsWith("text/plain") && UUEncodedMultiPart.isUUEncoded(content) && (uuencodedMP = new UUEncodedMultiPart(content)).isUUEncoded()) {
                    content = uuencodedMP.getCleanText();
                    textPart = this.createPartFromPlainText(content);
                }
                return textPart;
            }
            if (ct.startsWith("multipart/alternative")) {
                int count = part.getEnclosedCount();
                MailPart textPart = null;
                for (int i = 0; i < count; ++i) {
                    MailPart p;
                    MailPart bp = part.getEnclosedMailPart(i);
                    ContentType bct = bp.getContentType();
                    if (bct.startsWith("text/plain")) {
                        if (textPart != null) continue;
                        textPart = this.getTextRecursive(bp);
                        continue;
                    }
                    if (!(bct.startsWith("text/htm") ? (p = this.getTextRecursive(bp)) != null : bct.startsWith("multipart/") && (p = this.getTextRecursive(bp)) != null)) continue;
                    return p;
                }
                return textPart;
            }
            if (ct.startsWith("multipart/")) {
                int count = part.getEnclosedCount();
                for (int i = 0; i < count; ++i) {
                    MailPart p = this.getTextRecursive(part.getEnclosedMailPart(i));
                    if (p == null) continue;
                    return p;
                }
            }
            if (TNEFUtils.isTNEFMimeType((String)ct.getBaseType())) {
                return this.handleTNEFPart(part);
            }
            return null;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private MailPart createPartFromPlainText(String content) throws OXException {
        try {
            MimeBodyPart mimePart = new MimeBodyPart();
            ContentType ct = new ContentType("text/plain");
            ct.setCharsetParameter("UTF-8");
            mimePart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(content.getBytes(Charsets.UTF_8), ct.toString())));
            mimePart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
            mimePart.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
            return MimeMessageConverter.convertPart((Part)mimePart, false);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private MailPart handleTNEFPart(MailPart part) throws OXException {
        return this.handleTNEFStream(part.getInputStream());
    }

    public MailPart handleTNEFStream(InputStream inputStream) throws OXException {
        try {
            RawInputStream ris;
            MAPIProp prop;
            TNEFInputStream tnefInputStream = new TNEFInputStream(inputStream);
            Message message = new Message(tnefInputStream);
            Attr messageClass = message.getAttribute(32776);
            String messageClassName = messageClass == null ? (null == (prop = message.getMAPIProps().getProp(26)) ? "" : prop.getValue().toString()) : (String)messageClass.getValue();
            if (TNEF_IPM_CONTACT.equalsIgnoreCase(messageClassName)) {
                return null;
            }
            if (TNEF_IPM_MS_READ_RECEIPT.equalsIgnoreCase(messageClassName)) {
                return null;
            }
            if (TNEF2ICal.isVPart(messageClassName)) {
                return null;
            }
            Attr attrBody = Attr.findAttr((List)message.getAttributes(), (int)32780);
            if (attrBody != null) {
                TNEFBodyPart bodyPart = new TNEFBodyPart();
                String value = (String)attrBody.getValue();
                MessageUtility.setText(value, (Part)bodyPart);
                bodyPart.setSize(value.length());
                MailPart p = this.getTextRecursive(MimeMessageConverter.convertPart((Part)bodyPart));
                if (null != p) {
                    return p;
                }
            }
            TNEFBodyPart rtfPart = null;
            MAPIProps mapiProps = message.getMAPIProps();
            if (mapiProps != null && (ris = (RawInputStream)mapiProps.getPropValue(4105)) != null) {
                rtfPart = new TNEFBodyPart();
                byte[] decompressedBytes = CompressedRTFInputStream.decompressRTF((byte[])ris.toByteArray());
                String contentTypeStr = "application/rtf";
                rtfPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(decompressedBytes, contentTypeStr)));
                rtfPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, contentTypeStr);
                rtfPart.setSize(decompressedBytes.length);
            }
            return this.getTextRecursive(MimeMessageConverter.convertPart(rtfPart));
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static String readContent(MailPart mailPart, ContentType contentType) throws OXException, IOException {
        String charset = TextPartFinder.getCharset(mailPart, contentType);
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "ISO-8859-1";
            LOG.warn("Character conversion exception while reading content with charset \"{}\". Using fallback charset \"{}\" instead.", new Object[]{charset, "ISO-8859-1", e});
            return MessageUtility.readMailPart(mailPart, "ISO-8859-1");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader(MessageHeaders.HDR_CONTENT_TYPE)) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                String prev = cs;
                if (contentType.startsWith("text/")) {
                    try {
                        cs = CharsetDetector.detectCharsetFailOnError((InputStream)mailPart.getInputStream());
                    }
                    catch (IOException e) {
                        cs = mailPart instanceof MimeRawSource ? CharsetDetector.detectCharset((InputStream)((MimeRawSource)((Object)mailPart)).getRawInputStream()) : CharsetDetector.getFallback();
                    }
                    LOG.warn("Illegal or unsupported encoding \"{}\". Using auto-detected encoding: \"{}\"", (Object)prev, (Object)cs);
                } else {
                    cs = MailProperties.getInstance().getDefaultMimeCharset();
                    LOG.warn("Illegal or unsupported encoding \"{}\". Using fallback encoding: \"{}\"", (Object)prev, (Object)cs);
                }
            }
            charset = cs;
        } else if (contentType.startsWith("text/")) {
            String cs;
            try {
                cs = CharsetDetector.detectCharsetFailOnError((InputStream)mailPart.getInputStream());
            }
            catch (IOException e) {
                cs = mailPart instanceof MimeRawSource ? CharsetDetector.detectCharset((InputStream)((MimeRawSource)((Object)mailPart)).getRawInputStream()) : CharsetDetector.getFallback();
            }
            charset = cs;
        } else {
            charset = MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }
}

