/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.search.ANDTerm;
import com.openexchange.mail.search.BccTerm;
import com.openexchange.mail.search.BodyTerm;
import com.openexchange.mail.search.CcTerm;
import com.openexchange.mail.search.FromTerm;
import com.openexchange.mail.search.ORTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SubjectTerm;
import com.openexchange.mail.search.ToTerm;

public final class SearchUtility {
    private SearchUtility() {
    }

    public static SearchTerm<?> parseFields(int[] searchFields, String[] patterns, boolean linkWithOR) {
        MailField[] fields = MailField.getFields(searchFields);
        SearchTerm retval = null;
        for (int i = 0; i < fields.length; ++i) {
            SearchTerm term;
            if (Strings.isEmpty((String)patterns[i])) continue;
            switch (fields[i]) {
                case FROM: {
                    term = new FromTerm(patterns[i]);
                    break;
                }
                case TO: {
                    term = new ToTerm(patterns[i]);
                    break;
                }
                case CC: {
                    term = new CcTerm(patterns[i]);
                    break;
                }
                case BCC: {
                    term = new BccTerm(patterns[i]);
                    break;
                }
                case SUBJECT: {
                    term = new SubjectTerm(patterns[i]);
                    break;
                }
                case BODY: {
                    term = new BodyTerm(patterns[i]);
                    break;
                }
                default: {
                    term = new BodyTerm(patterns[i]);
                }
            }
            retval = retval == null ? term : (linkWithOR ? new ORTerm(retval, term) : new ANDTerm(retval, term));
        }
        return retval;
    }
}

