/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils.sourcedimage;

import com.openexchange.java.util.UUIDs;
import com.openexchange.mail.mime.utils.sourcedimage.SourcedImage;
import com.openexchange.tools.regex.MatcherReplacer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SourcedImageUtility {
    private static final Pattern PATTERN_SOURCED_IMG = Pattern.compile("(<img[^>]+src=\")data:([a-zA-Z]+/[a-zA-Z-.]+);([a-zA-Z0-9-_]+),([^\"]+)(\"[^>]*/?>)", 34);

    private SourcedImageUtility() {
    }

    public static Map<String, SourcedImage> hasSourcedImages(StringBuilder htmlContent) {
        String toParse = htmlContent.toString();
        Matcher m = PATTERN_SOURCED_IMG.matcher(toParse);
        if (!m.find()) {
            return Collections.emptyMap();
        }
        htmlContent.setLength(0);
        MatcherReplacer mr = new MatcherReplacer(m, toParse);
        HashMap<String, SourcedImage> map = new HashMap<String, SourcedImage>(4);
        StringBuilder tmp = new StringBuilder(48);
        do {
            String cid = tmp.append(UUIDs.getUnformattedString((UUID)UUID.randomUUID())).append('@').append("Open-Xchange").toString();
            tmp.setLength(0);
            String prefix = m.group(1);
            String appendix = m.group(5);
            map.put(cid, new SourcedImage(m.group(2), m.group(3), cid, m.group(4)));
            mr.appendLiteralReplacement(htmlContent, tmp.append(prefix).append("cid:").append(cid).append(appendix).toString());
            tmp.setLength(0);
        } while (m.find());
        mr.appendTail(htmlContent);
        return map;
    }
}

