/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.UnifiedInboxUID;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeProcessingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(MimeProcessingUtility.class);
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_SPECIAL2 = new String[]{"rfc822-headers", "vcard", "x-vcard", "calendar", "x-vcalendar"};
    private static final String TEXT = "text/";
    private static final String CT_TEXT_HTM = "text/htm";
    private static final String DUMMY_DOMAIN = "@unspecified-domain";

    private MimeProcessingUtility() {
    }

    private static User getUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
    }

    private static UserSettingMail getUserSettingMail(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUserSettingMail();
        }
        return UserSettingMailStorage.getInstance().getUserSettingMail(session);
    }

    static int isKnownAddress(Session session, InternetAddress address) throws OXException {
        QuotedInternetAddress addr = new QuotedInternetAddress();
        addr.setAddress(address.getAddress());
        HashSet<InternetAddress> validAddrs = new HashSet<InternetAddress>(4);
        User user = MimeProcessingUtility.getUser(session);
        for (String alias : user.getAliases()) {
            QuotedInternetAddress a = new QuotedInternetAddress();
            a.setAddress(alias);
            validAddrs.add(a);
        }
        if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
            MsisdnUtility.addMsisdnAddress(validAddrs, session);
            String sAddress = addr.getAddress();
            int pos = sAddress.indexOf(47);
            if (pos > 0) {
                addr.setAddress(sAddress.substring(0, pos));
            }
        }
        if (validAddrs.contains((Object)addr)) {
            return 0;
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
        int userId = session.getUserId();
        int contextId = session.getContextId();
        int accountId = storageService.getByPrimaryAddress(addr.getAddress(), userId, contextId);
        if (accountId != -1) {
            accountId = storageService.getByPrimaryAddress(IDNA.toIDN((String)addr.getAddress()), userId, contextId);
        }
        return accountId;
    }

    static int resolveFrom2Account(Session session, InternetAddress[] from) throws OXException {
        if (null == from || from.length == 0) {
            return 0;
        }
        return MimeProcessingUtility.resolveFrom2Account(session, from[0]);
    }

    static int resolveFrom2Account(Session session, InternetAddress from) throws OXException {
        int accountId;
        if (null == from) {
            accountId = 0;
        } else {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            int user = session.getUserId();
            int cid = session.getContextId();
            accountId = storageService.getByPrimaryAddress(from.getAddress(), user, cid);
            if (accountId != -1) {
                accountId = storageService.getByPrimaryAddress(IDNA.toIDN((String)from.getAddress()), user, cid);
            }
        }
        if (accountId == -1) {
            accountId = 0;
        }
        return accountId;
    }

    static InternetAddress determinePossibleFrom(boolean isForward, MailMessage origMsg, int accountId, Session session, Context ctx) throws OXException {
        HashSet<Object> fromCandidates;
        QuotedInternetAddress likely = null;
        if (accountId == 0) {
            if (isForward) {
                return null;
            }
            fromCandidates = new HashSet<InternetAddress>(8);
            likely = new QuotedInternetAddress();
            likely.setAddress(MimeProcessingUtility.getUserSettingMail(session).getSendAddr());
            MimeProcessingUtility.addUserAliases(fromCandidates, session, ctx);
        } else {
            ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
            UnifiedInboxManagement management = registry.getService(UnifiedInboxManagement.class);
            if (null != management && accountId == management.getUnifiedINBOXAccountID(session)) {
                int realAccountId;
                try {
                    UnifiedInboxUID uid = new UnifiedInboxUID(origMsg.getMailId());
                    realAccountId = uid.getAccountId();
                }
                catch (OXException e) {
                    FullnameArgument fa = UnifiedInboxUID.parsePossibleNestedFullName(origMsg.getFolder());
                    int n = realAccountId = null == fa ? 0 : fa.getAccountId();
                }
                if (realAccountId == 0) {
                    if (isForward) {
                        return null;
                    }
                    fromCandidates = new HashSet(8);
                    likely = new QuotedInternetAddress();
                    likely.setAddress(MimeProcessingUtility.getUserSettingMail(session).getSendAddr());
                    MimeProcessingUtility.addUserAliases(fromCandidates, session, ctx);
                } else {
                    MailAccountStorageService mass = registry.getService(MailAccountStorageService.class);
                    if (null == mass) {
                        if (isForward) {
                            return null;
                        }
                        fromCandidates = new HashSet(8);
                        likely = new QuotedInternetAddress();
                        likely.setAddress(MimeProcessingUtility.getUserSettingMail(session).getSendAddr());
                        MimeProcessingUtility.addUserAliases(fromCandidates, session, ctx);
                    } else {
                        QuotedInternetAddress a = new QuotedInternetAddress();
                        a.setAddress(mass.getMailAccount(realAccountId, session.getUserId(), session.getContextId()).getPrimaryAddress());
                        if (isForward) {
                            return a;
                        }
                        fromCandidates = new HashSet(2);
                        likely = a;
                        fromCandidates.add((InternetAddress)a);
                    }
                }
            } else {
                MailAccountStorageService mass = registry.getService(MailAccountStorageService.class);
                if (null == mass) {
                    if (isForward) {
                        return null;
                    }
                    fromCandidates = new HashSet(8);
                    likely = new QuotedInternetAddress();
                    likely.setAddress(MimeProcessingUtility.getUserSettingMail(session).getSendAddr());
                    MimeProcessingUtility.addUserAliases(fromCandidates, session, ctx);
                } else {
                    QuotedInternetAddress a = new QuotedInternetAddress();
                    a.setAddress(mass.getMailAccount(accountId, session.getUserId(), session.getContextId()).getPrimaryAddress());
                    if (isForward) {
                        return a;
                    }
                    fromCandidates = new HashSet(2);
                    likely = a;
                    fromCandidates.add((InternetAddress)a);
                }
            }
        }
        InternetAddress from = null;
        String hdrVal = origMsg.getHeader(MessageHeaders.HDR_TO, ",");
        InternetAddress[] toAddrs = null;
        if (hdrVal != null) {
            for (InternetAddress addr : toAddrs = MimeMessageUtility.parseAddressList(hdrVal, true)) {
                if (!fromCandidates.contains(addr)) continue;
                from = addr;
                break;
            }
        }
        if (null == from && (hdrVal = origMsg.getHeader(MessageHeaders.HDR_CC, ",")) != null) {
            for (InternetAddress addr : toAddrs = MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)) {
                if (!fromCandidates.contains(addr)) continue;
                from = addr;
                break;
            }
        }
        if (null == from && (hdrVal = origMsg.getHeader(MessageHeaders.HDR_BCC, ",")) != null) {
            for (InternetAddress addr : toAddrs = MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)) {
                if (!fromCandidates.contains(addr)) continue;
                from = addr;
                break;
            }
        }
        return null == from ? likely : from;
    }

    static void addUserAliases(Set<InternetAddress> set, Session session, Context ctx) throws OXException {
        String[] userAddrs = UserStorage.getInstance().getUser(session.getUserId(), ctx).getAliases();
        if (userAddrs != null && userAddrs.length > 0) {
            StringBuilder addrBuilder = new StringBuilder();
            addrBuilder.append(userAddrs[0]);
            for (int i = 1; i < userAddrs.length; ++i) {
                addrBuilder.append(',').append(userAddrs[i]);
            }
            set.addAll(Arrays.asList(MimeMessageUtility.parseAddressList(addrBuilder.toString(), false)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String getFolderOwnerIfShared(String fullName, int accountId, Session session) {
        if (null == fullName) {
            return null;
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, accountId);
            access.connect(false);
            MailFolder folder = access.getFolderStorage().getFolder(fullName);
            String string = folder.isShared() ? folder.getOwner() : null;
            return string;
        }
        catch (Exception e) {
            LOG.warn("Couldn't resolve owner for {}", (Object)fullName, (Object)e);
            String string = null;
            return string;
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    public static final String getFormattedDate(Date date, int style, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getDateInstance(style, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    static final String getFormattedTime(Date date, int style, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat = DateFormat.getTimeInstance(style, locale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    static boolean isInline(MailPart part, ContentType contentType) throws OXException {
        boolean hasDisposition;
        ContentDisposition cd;
        String[] hdr = part.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION);
        if (null == hdr) {
            cd = new ContentDisposition();
            hasDisposition = false;
        } else {
            cd = new ContentDisposition(hdr[0]);
            hasDisposition = true;
        }
        return hasDisposition && "inline".equalsIgnoreCase(cd.getDisposition()) || !hasDisposition && !cd.containsFilenameParameter() && !contentType.containsParameter("name");
    }

    static boolean fileNameEndsWith(String suffix, MailPart part, ContentType contentType) throws OXException {
        String filename = MimeProcessingUtility.getFileName(part, contentType);
        return null == filename ? false : filename.toLowerCase(Locale.ENGLISH).endsWith(suffix);
    }

    private static String getFileName(MailPart part, ContentType contentType) throws OXException {
        String[] hdr = part.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION);
        ContentDisposition cd = null == hdr ? new ContentDisposition() : new ContentDisposition(hdr[0]);
        String filename = cd.getFilenameParameter();
        if (null == filename) {
            filename = contentType.getParameter("name");
        }
        return MimeMessageUtility.decodeMultiEncodedHeader(filename);
    }

    static String handleInlineTextPart(MailPart textPart, ContentType contentType, boolean allowHTML) throws IOException, OXException {
        String charset = MimeProcessingUtility.getCharset(textPart, contentType);
        if (contentType.isMimeType("text/htm*")) {
            if (allowHTML) {
                return MimeProcessingUtility.readContent(textPart, charset);
            }
            contentType.setBaseType("text/plain");
            HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
            return htmlService.html2text(MimeProcessingUtility.readContent(textPart, charset), false);
        }
        if (contentType.isMimeType("text/plain")) {
            String content = MimeProcessingUtility.readContent(textPart, charset);
            UUEncodedMultiPart uuencodedMP = new UUEncodedMultiPart(content);
            if (uuencodedMP.isUUEncoded()) {
                return uuencodedMP.getCleanText();
            }
            return content;
        }
        return MimeProcessingUtility.readContent(textPart, charset);
    }

    public static boolean isSpecial(String contentType) {
        if (null == contentType) {
            return false;
        }
        String ct = contentType.toLowerCase(Locale.US);
        if (ct.startsWith("text/", 0)) {
            int off = "text/".length();
            for (String subtype : SUB_SPECIAL2) {
                if (!ct.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    static String readContent(MailPart mailPart, String charset) throws OXException, IOException {
        try {
            return MessageUtility.readMailPart(mailPart, charset);
        }
        catch (CharConversionException e) {
            String fallback = "US-ASCII";
            LOG.warn("Character conversion exception while reading content with charset \"{}\". Using fallback charset \"{}\" instead.", new Object[]{charset, "US-ASCII", e});
            return MessageUtility.readMailPart(mailPart, "US-ASCII");
        }
    }

    private static String getCharset(MailPart mailPart, ContentType contentType) throws OXException {
        String charset;
        if (mailPart.containsHeader(MessageHeaders.HDR_CONTENT_TYPE)) {
            String cs = contentType.getCharsetParameter();
            if (!CharsetDetector.isValid((String)cs)) {
                if (null != cs) {
                    LOG.warn("Illegal or unsupported encoding in a message detected: \"{}\"", (Object)cs, (Object)new UnsupportedEncodingException(cs));
                }
                cs = contentType.startsWith("text/") ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
            }
            charset = cs;
        } else {
            charset = contentType.startsWith("text/") ? CharsetDetector.detectCharset((InputStream)mailPart.getInputStream()) : MailProperties.getInstance().getDefaultMimeCharset();
        }
        return charset;
    }

    public static String addrs2String(InternetAddress[] addrs) {
        StringBuilder tmp = new StringBuilder(addrs.length << 4);
        boolean first = true;
        for (InternetAddress addr : addrs) {
            String string = MimeProcessingUtility.addr2String(addr);
            if (Strings.isEmpty((String)string)) continue;
            if (first) {
                first = false;
            } else {
                tmp.append(", ");
            }
            tmp.append(string);
        }
        return first ? "" : tmp.toString();
    }

    static String addr2String(InternetAddress addr) {
        int pos;
        if (null == addr) {
            return "";
        }
        String sAddress = addr.getAddress();
        int n = pos = null == sAddress ? 0 : sAddress.indexOf(47);
        if (pos <= 0) {
            return addr.toUnicodeString();
        }
        StringBuilder sb = new StringBuilder(32);
        String personal = addr.getPersonal();
        if (null == personal) {
            sb.append(MimeProcessingUtility.prepareAddress(sAddress.substring(0, pos)));
        } else {
            sb.append(MimeProcessingUtility.preparePersonal(personal));
            sb.append(" <").append(MimeProcessingUtility.prepareAddress(sAddress.substring(0, pos))).append('>');
        }
        return sb.toString();
    }

    static void appendRightVersion(ContentType rootType, ContentType contentType, String text, StringBuilder textBuilder) {
        if (rootType.getBaseType().equalsIgnoreCase(contentType.getBaseType())) {
            textBuilder.append(text);
        } else if (rootType.startsWith(CT_TEXT_HTM)) {
            textBuilder.append(HtmlProcessing.htmlFormat(text));
        } else {
            textBuilder.append(ServerServiceRegistry.getInstance().getService(HtmlService.class).html2text(text, false));
        }
    }

    static String preparePersonal(String personal) {
        return MimeMessageUtility.quotePhrase(personal, false);
    }

    static String prepareAddress(String address) {
        String decoded = QuotedInternetAddress.toIDN(MimeMessageUtility.decodeMultiEncodedHeader(address));
        int pos = decoded.indexOf(DUMMY_DOMAIN);
        if (pos >= 0) {
            return decoded.substring(0, pos);
        }
        return decoded;
    }
}

