/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.filler;

import com.openexchange.contact.ContactService;
import com.openexchange.contact.internal.VCardUtil;
import com.openexchange.contact.vcard.VCardExport;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.filler.CompositionParameters;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;

public final class SessionCompositionParameters
implements CompositionParameters {
    private final Session session;
    private final Context ctx;
    private final UserSettingMail usm;
    private int accountId = 0;

    public SessionCompositionParameters(Session session, Context ctx, UserSettingMail usm) {
        this.session = session;
        this.ctx = ctx;
        this.usm = usm;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    @Override
    public String getOrganization() throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        return contactService.getOrganization(this.session);
    }

    @Override
    public String getClient() throws OXException {
        return this.session.getClient();
    }

    @Override
    public String getOriginatingIP() throws OXException {
        String origIp = this.session.getLocalIp();
        if (MimeMessageFiller.isLocalhost(origIp)) {
            MimeMessageFiller.LOG.debug("Session provides localhost as client IP address: {}", (Object)origIp);
            origIp = LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.GRIZZLY_REMOTE_ADDRESS);
        }
        return origIp;
    }

    @Override
    public InternetAddress getSenderAddress(InternetAddress from) throws OXException, AddressException {
        QuotedInternetAddress sender = null;
        MailAccountStorageService mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
        if (null != mass) {
            try {
                String sendAddr;
                int userId = this.session.getUserId();
                int contextId = this.session.getContextId();
                int id = mass.getByPrimaryAddress(from.getAddress(), userId, contextId);
                if (id < 0 && (id = mass.getByPrimaryAddress(IDNA.toIDN((String)from.getAddress()), userId, contextId)) < 0 && (sendAddr = this.usm.getSendAddr()) != null && sendAddr.length() > 0) {
                    try {
                        sender = new QuotedInternetAddress(sendAddr, true);
                    }
                    catch (AddressException e) {
                        MimeMessageFiller.LOG.error("Default send address cannot be parsed", (Throwable)e);
                    }
                }
            }
            catch (OXException e) {
                MimeMessageFiller.LOG.debug("", (Throwable)e);
            }
        }
        if (sender != null || !from.equals(sender)) {
            UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, true);
            User user = userService.getUser(this.session.getUserId(), this.ctx);
            LinkedHashSet<InternetAddress> aliases = new LinkedHashSet<InternetAddress>();
            for (String alias : user.getAliases()) {
                aliases.add(new QuotedInternetAddress(alias));
            }
            if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
                MsisdnUtility.addMsisdnAddress(aliases, this.session);
                String address = from.getAddress();
                int pos = address.indexOf(47);
                if (pos > 0) {
                    from.setAddress(address.substring(0, pos));
                }
            }
            if (from.equals(sender) || aliases.contains((Object)sender)) {
                sender = null;
            }
        }
        return sender;
    }

    @Override
    public String getTimeZoneID() throws OXException {
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, true);
        User user = userService.getUser(this.session.getUserId(), this.ctx);
        return user.getTimeZone();
    }

    @Override
    public boolean setReplyTo() {
        return true;
    }

    @Override
    public String getReplyToAddress() throws OXException {
        String sReplyTo;
        MailAccount mailAccount;
        MailAccountStorageService mass;
        String replyTo = this.usm.getReplyToAddr();
        if (Strings.isEmpty((String)replyTo) && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class)) && !UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals((mailAccount = mass.getMailAccount(this.accountId, this.session.getUserId(), this.session.getContextId())).getMailProtocol()) && !Strings.isEmpty((String)(sReplyTo = mailAccount.getReplyTo())) && !Strings.toLowerCase((CharSequence)sReplyTo).startsWith("null")) {
            replyTo = sReplyTo;
        }
        return replyTo;
    }

    @Override
    public String getEnvelopeFrom() throws OXException {
        String address = UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getMail();
        try {
            return IDNA.toACE((String)address);
        }
        catch (AddressException e) {
            throw MimeMailExceptionCode.INVALID_EMAIL_ADDRESS.create(address);
        }
    }

    @Override
    public Locale getLocale() throws OXException {
        return UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getLocale();
    }

    @Override
    public String getUserVCardFileName() throws OXException {
        String displayName = this.session instanceof ServerSession ? ((ServerSession)this.session).getUser().getDisplayName() : UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getDisplayName();
        String saneDisplayName = Strings.replaceWhitespacesWith((String)displayName, (String)"");
        return saneDisplayName + ".vcf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getUserVCard() throws OXException {
        byte[] byArray;
        Contact contact = ServerServiceRegistry.getInstance().getService(ContactService.class).getUser(this.session, this.session.getUserId());
        VCardExport vCardExport = null;
        try {
            vCardExport = VCardUtil.exportContact(contact, this.session);
            byArray = vCardExport.toByteArray();
        }
        catch (Throwable throwable) {
            Streams.close(vCardExport);
            throw throwable;
        }
        Streams.close((Closeable)vCardExport);
        return byArray;
    }

    @Override
    public int getAutoLinebreak() {
        return this.usm.getAutoLinebreak();
    }

    @Override
    public boolean isForwardAsAttachment() {
        return this.usm.isForwardAsAttachment();
    }

    @Override
    public MimeMessageFiller.ImageProvider createImageProvider(ImageDataSource dataSource, ImageLocation imageLocation) throws OXException {
        return new MimeMessageFiller.ImageDataImageProvider(dataSource, imageLocation, this.session);
    }
}

