/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public final class DocumentDataSource
implements DataSource {
    private final Session session;
    private final String documentId;
    private final String name;
    private final String contentType;

    public DocumentDataSource(String documentId, String contentType, String name, Session session) {
        this.documentId = documentId;
        this.contentType = contentType;
        this.name = name;
        this.session = session;
    }

    private static IDBasedFileAccess fileAccess(Session session) throws OXException {
        return ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true).createAccess(session);
    }

    public InputStream getInputStream() throws IOException {
        IDBasedFileAccess fileAccess = null;
        try {
            fileAccess = DocumentDataSource.fileAccess(this.session);
            InputStream inputStream = fileAccess.getDocument(this.documentId, FileStorageFileAccess.CURRENT_VERSION);
            return inputStream;
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Input stream cannot be retrieved", e);
        }
        finally {
            DocumentDataSource.finishSafe(fileAccess);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("DocumentDataSource.getOutputStream()");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    private static void finishSafe(IDBasedFileAccess fileAccess) {
        if (fileAccess != null) {
            try {
                fileAccess.finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

