/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessageRemovedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MimeFileStoreMailPart
extends MailPart {
    private static final long serialVersionUID = 257902073011243269L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MimeFileStoreMailPart.class);
    private final IDBasedFileAccessFactory fileAccessFactory;
    private final int userId;
    private final int contextId;
    private final String id;
    private transient MessageDataSource dataSource;
    private transient Object cachedContent;
    private static final String TEXT = "text/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MimeFileStoreMailPart(DataSource dataSource, long size, Session session) throws OXException {
        try {
            DefaultFile file = new DefaultFile();
            file.setId(FileStorageFileAccess.NEW);
            file.setFolderId(String.valueOf(new OXFolderAccess(MimeFileStoreMailPart.getContextFrom(session)).getDefaultFolderID(session.getUserId(), 8)));
            String name = dataSource.getName();
            this.setContentType(MimeFileStoreMailPart.prepareContentType(dataSource.getContentType(), name));
            if (this.getContentType().getCharsetParameter() == null && this.getContentType().startsWith(TEXT)) {
                String cs = CharsetDetector.detectCharset((InputStream)dataSource.getInputStream());
                this.getContentType().setCharsetParameter(cs);
            }
            file.setFileName(name);
            file.setFileMIMEType(this.getContentType().toString());
            file.setTitle(name);
            file.setFileSize(size);
            this.fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            IDBasedFileAccess fileAccess = this.fileAccessFactory.createAccess(session);
            boolean retry = true;
            int count = 1;
            StringBuilder hlp = new StringBuilder(16);
            while (retry) {
                InputStream in = dataSource.getInputStream();
                try {
                    fileAccess.startTransaction();
                    try {
                        fileAccess.saveDocument((File)file, in, Long.MAX_VALUE);
                        fileAccess.commit();
                        retry = false;
                    }
                    catch (OXException x) {
                        fileAccess.rollback();
                        if (!x.isPrefix("IFO")) {
                            throw x;
                        }
                        if (441 != x.getCode()) {
                            throw x;
                        }
                        hlp.setLength(0);
                        int pos = name.lastIndexOf(46);
                        String newName = pos >= 0 ? hlp.append(name.substring(0, pos)).append("_(").append(++count).append(')').append(name.substring(pos)).toString() : hlp.append(name).append("_(").append(++count).append(')').toString();
                        file.setFileName(newName);
                        file.setTitle(newName);
                    }
                    catch (RuntimeException e) {
                        fileAccess.rollback();
                        throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                    }
                    finally {
                        fileAccess.finish();
                    }
                }
                finally {
                    Streams.close((Closeable)in);
                }
            }
            this.id = String.valueOf(file.getId());
            this.userId = session.getUserId();
            this.contextId = session.getContextId();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private static Context getContextFrom(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    private Session getSession() throws OXException {
        Collection sessions = ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSessions(this.userId, this.contextId);
        if (null == sessions || sessions.isEmpty()) {
            throw MailExceptionCode.MISSING_FIELD.create("session");
        }
        return (Session)sessions.iterator().next();
    }

    private static String prepareContentType(String contentType, String preparedFileName) {
        if (null == contentType || contentType.length() == 0) {
            return "application/octet-stream";
        }
        int mlen = contentType.length() - 1;
        String retval = 0 == contentType.indexOf(34) && mlen == contentType.lastIndexOf(34) ? contentType.substring(1, mlen) : contentType;
        if ("multipart/form-data".equalsIgnoreCase(retval)) {
            return MimeType2ExtMap.getContentType(preparedFileName);
        }
        return contentType;
    }

    private MessageDataSource getDataSource() throws OXException {
        if (null == this.dataSource) {
            try {
                ContentType contentType = this.getContentType();
                MessageDataSource mds = new MessageDataSource(this.fileAccessFactory.createAccess(this.getSession()).getDocument(this.id, FileStorageFileAccess.CURRENT_VERSION), contentType);
                if (contentType.getCharsetParameter() == null && contentType.startsWith(TEXT)) {
                    String cs = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(mds.getData()));
                    contentType.setCharsetParameter(cs);
                    mds.setContentType(contentType.toString());
                }
                this.dataSource = mds;
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    public String getFileId() {
        return this.id;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            MessageDataSource mds = this.getDataSource();
            String charset = this.getContentType().getCharsetParameter();
            if (charset == null) {
                charset = "UTF-8";
            }
            try {
                this.cachedContent = new String(mds.getData(), Charsets.forName((String)charset));
            }
            catch (UnsupportedCharsetException e) {
                throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
            }
            return this.cachedContent;
        }
        return null;
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler((DataSource)this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            return this.getDataSource().getInputStream();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void loadContent() {
    }

    @Override
    public void prepareForCaching() {
    }
}

