/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotaExceededException;
import com.openexchange.session.Session;
import com.openexchange.tools.exceptions.ExceptionUtils;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPSendTimedoutException;
import com.sun.mail.smtp.SMTPSenderFailedException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.IllegalWriteException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.NoSuchProviderException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.SendFailedException;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import javax.mail.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMailException
extends OXException {
    private static final transient Logger LOG = LoggerFactory.getLogger(MimeMailException.class);
    private static final long serialVersionUID = -3401580182929349354L;
    private static final String STR_EMPTY = "";
    private static final String ERR_TMP = "temporary error, please try again later";
    private static final String ERR_TMP_FLR = "temporary failure";
    private static final String ERR_AUTH_FAILED = "bad authentication failed";
    private static final String ERR_MSG_TOO_LARGE = "message too large";
    private static final String ERR_QUOTA = "quota";
    private static final String EXC_CONNECTION_RESET_EXCEPTION = "ConnectionResetException";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Pattern PATTERN_TAG = Pattern.compile("A[0-9]+ (.+)");

    public MimeMailException(int code, String displayMessage, Object ... displayArgs) {
        super(code, displayMessage, displayArgs);
    }

    public MimeMailException(int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(code, displayMessage, cause, displayArgs);
    }

    public static OXException handleMessagingException(MessagingException e) {
        return MimeMailException.handleMessagingException(e, null, null);
    }

    public static OXException handleMessagingException(MessagingException e, MailConfig mailConfig) {
        return MimeMailException.handleMessagingException(e, mailConfig, mailConfig.getSession());
    }

    public static OXException handleMessagingException(MessagingException e, MailConfig mailConfig, Session session) {
        return MimeMailException.handleMessagingException(e, mailConfig, session, null);
    }

    public static OXException handleMessagingException(MessagingException e, MailConfig mailConfig, Session session, Folder folder) {
        try {
            if (null != mailConfig) {
                LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_ACCOUNT_ID, (Object)mailConfig.getAccountId());
                LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_HOST, (Object)mailConfig.getServer());
                LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_LOGIN, (Object)mailConfig.getLogin());
                if (null != folder) {
                    LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME, (Object)folder.getFullName());
                }
            }
            if (e instanceof MessageRemovedException) {
                if (null != folder) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(e, STR_EMPTY, folder.getFullName());
                }
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            if (e instanceof AuthenticationFailedException || MimeMailException.toLowerCase(e.getMessage(), STR_EMPTY).indexOf(ERR_AUTH_FAILED) != -1) {
                if (null != mailConfig && 0 == mailConfig.getAccountId()) {
                    return MimeMailExceptionCode.LOGIN_FAILED.create(e, mailConfig.getServer(), mailConfig.getLogin());
                }
                if (e.getMessage() != null && ERR_TMP.equals(Strings.toLowerCase((CharSequence)e.getMessage()))) {
                    return MimeMailExceptionCode.LOGIN_FAILED.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
                }
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.INVALID_CREDENTIALS_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), e.getMessage());
                }
                return MimeMailExceptionCode.INVALID_CREDENTIALS.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), e.getMessage());
            }
            if (e instanceof FolderClosedException) {
                Folder f = ((FolderClosedException)e).getFolder();
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.FOLDER_CLOSED_EXT.create(e, null == f ? MimeMailException.appendInfo(e.getMessage(), folder) : f.getFullName(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.FOLDER_CLOSED.create(e, null == f ? MimeMailException.appendInfo(e.getMessage(), folder) : f.getFullName());
            }
            if (e instanceof FolderNotFoundException) {
                Folder f = ((FolderNotFoundException)e).getFolder();
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.FOLDER_NOT_FOUND_EXT.create(e, null == f ? MimeMailException.appendInfo(e.getMessage(), folder) : f.getFullName(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.FOLDER_NOT_FOUND.create(e, null == f ? MimeMailException.appendInfo(e.getMessage(), folder) : f.getFullName());
            }
            if (e instanceof IllegalWriteException) {
                return MimeMailExceptionCode.ILLEGAL_WRITE.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof MessageRemovedException) {
                return MimeMailExceptionCode.MESSAGE_REMOVED.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof MethodNotSupportedException) {
                return MimeMailExceptionCode.METHOD_NOT_SUPPORTED.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof NoSuchProviderException) {
                return MimeMailExceptionCode.NO_SUCH_PROVIDER.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof ParseException) {
                if (e instanceof AddressException) {
                    String optRef = ((AddressException)((Object)e)).getRef();
                    return MimeMailExceptionCode.INVALID_EMAIL_ADDRESS.create(e, optRef == null ? STR_EMPTY : optRef);
                }
                return MimeMailExceptionCode.PARSE_ERROR.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof ReadOnlyFolderException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.READ_ONLY_FOLDER_EXT.create(e, MimeMailException.appendInfo(e.getMessage(), folder), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.READ_ONLY_FOLDER.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof SearchException) {
                return MimeMailExceptionCode.SEARCH_ERROR.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (e instanceof SMTPSendTimedoutException) {
                SMTPSendTimedoutException timedoutException = (SMTPSendTimedoutException)e;
                String cmd = timedoutException.getCommand();
                InternetAddress addr = timedoutException.getAddr();
                return MimeMailExceptionCode.SEND_TIMED_OUT_ERROR.create(e, addr.toUnicodeString(), cmd);
            }
            if (e instanceof SMTPSenderFailedException) {
                SMTPSenderFailedException failedException = (SMTPSenderFailedException)e;
                SmtpInfo smtpInfo = MimeMailException.getSmtpInfo(failedException);
                if (smtpInfo.retCode == 552 || MimeMailException.toLowerCase(smtpInfo.message, STR_EMPTY).indexOf(ERR_MSG_TOO_LARGE) > -1) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE_EXT.create((Throwable)failedException, smtpInfo.toString());
                }
                return MimeMailExceptionCode.SEND_FAILED_MSG_EXT_ERROR.create((Throwable)failedException, failedException.getMessage(), smtpInfo.toString());
            }
            if (e instanceof SMTPAddressFailedException) {
                SMTPAddressFailedException failedException = (SMTPAddressFailedException)e;
                SmtpInfo smtpInfo = MimeMailException.getSmtpInfo(failedException);
                if (smtpInfo.retCode == 552 || MimeMailException.toLowerCase(smtpInfo.message, STR_EMPTY).indexOf(ERR_MSG_TOO_LARGE) > -1) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE_EXT.create((Throwable)failedException, smtpInfo.toString());
                }
                return MimeMailExceptionCode.SEND_FAILED_MSG_EXT_ERROR.create((Throwable)failedException, failedException.getMessage(), smtpInfo.toString());
            }
            if (e instanceof SMTPSendFailedException) {
                SMTPSendFailedException sendFailedError = (SMTPSendFailedException)e;
                SmtpInfo smtpInfo = MimeMailException.getSmtpInfo(sendFailedError);
                if (smtpInfo.retCode == 552 || MimeMailException.toLowerCase(smtpInfo.message, STR_EMPTY).indexOf(ERR_MSG_TOO_LARGE) > -1) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE_EXT.create((Throwable)sendFailedError, smtpInfo.toString());
                }
                if (sendFailedError.getReturnCode() == 452 && MimeMailException.toLowerCase(sendFailedError.getMessage(), STR_EMPTY).indexOf(ERR_TMP_FLR) > -1) {
                    return MimeMailExceptionCode.TEMPORARY_FAILURE.create((Throwable)sendFailedError, MimeMailException.getSmtpInfo(sendFailedError));
                }
                Object[] addrs = sendFailedError.getInvalidAddresses();
                if (!(null != addrs && addrs.length != 0 || null != (addrs = sendFailedError.getValidUnsentAddresses()) && addrs.length != 0)) {
                    return MimeMailExceptionCode.SEND_FAILED_MSG_ERROR.create((Throwable)sendFailedError, smtpInfo.toString());
                }
                return MimeMailExceptionCode.SEND_FAILED_EXT.create((Throwable)sendFailedError, Arrays.toString(addrs), smtpInfo.toString());
            }
            if (e instanceof SendFailedException) {
                SendFailedException exc = (SendFailedException)e;
                SmtpInfo smtpInfo = null;
                Object[] invalidAddresses = exc.getInvalidAddresses();
                Exception nextException = exc.getNextException();
                if (nextException instanceof SMTPSendFailedException) {
                    SMTPSendFailedException failedError = (SMTPSendFailedException)nextException;
                    smtpInfo = MimeMailException.getSmtpInfo(failedError);
                    if (!(invalidAddresses != null && invalidAddresses.length != 0 || null != (invalidAddresses = failedError.getInvalidAddresses()) && invalidAddresses.length != 0)) {
                        invalidAddresses = failedError.getValidUnsentAddresses();
                    }
                } else if (nextException instanceof SMTPSenderFailedException) {
                    SMTPSenderFailedException failedError = (SMTPSenderFailedException)nextException;
                    smtpInfo = MimeMailException.getSmtpInfo(failedError);
                    if (!(invalidAddresses != null && invalidAddresses.length != 0 || null != (invalidAddresses = failedError.getInvalidAddresses()) && invalidAddresses.length != 0)) {
                        invalidAddresses = failedError.getValidUnsentAddresses();
                    }
                } else if (nextException instanceof SMTPAddressFailedException) {
                    SMTPAddressFailedException failedError = (SMTPAddressFailedException)nextException;
                    smtpInfo = MimeMailException.getSmtpInfo(failedError);
                    if (!(invalidAddresses != null && invalidAddresses.length != 0 || null != (invalidAddresses = failedError.getInvalidAddresses()) && invalidAddresses.length != 0)) {
                        invalidAddresses = failedError.getValidUnsentAddresses();
                    }
                }
                if (null != smtpInfo && (smtpInfo.retCode == 552 || MimeMailException.toLowerCase(smtpInfo.message, STR_EMPTY).indexOf(ERR_MSG_TOO_LARGE) > -1)) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE_EXT.create((Throwable)exc, smtpInfo.toString());
                }
                if (null == invalidAddresses || invalidAddresses.length == 0) {
                    return MimeMailExceptionCode.SEND_FAILED_MSG_ERROR.create((Throwable)exc, null == smtpInfo ? exc.getMessage() : smtpInfo.toString());
                }
                return MimeMailExceptionCode.SEND_FAILED_EXT.create((Throwable)exc, Arrays.toString(invalidAddresses), null == smtpInfo ? exc.getMessage() : smtpInfo.toString());
            }
            if (e instanceof StoreClosedException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.STORE_CLOSED_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), EMPTY_ARGS);
                }
                return MimeMailExceptionCode.STORE_CLOSED.create(e, EMPTY_ARGS);
            }
            Exception nextException = e.getNextException();
            if (nextException == null) {
                if (MimeMailException.toLowerCase(e.getMessage(), STR_EMPTY).indexOf(ERR_QUOTA) != -1) {
                    return MimeMailExceptionCode.QUOTA_EXCEEDED.create(e, MimeMailException.getInfo(MimeMailException.skipTag(e.getMessage())));
                }
                if ("Unable to load BODYSTRUCTURE".equals(e.getMessage())) {
                    return MimeMailExceptionCode.MESSAGE_NOT_DISPLAYED.create(e, EMPTY_ARGS);
                }
                String message = Strings.toLowerCase((CharSequence)e.getMessage());
                if ("failed to load imap envelope".equals(message)) {
                    return MimeMailExceptionCode.MESSAGE_NOT_DISPLAYED.create(e, new Object[0]);
                }
                if ("connection failure".equals(e.getMessage())) {
                    return MimeMailExceptionCode.NO_ROUTE_TO_HOST.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer());
                }
                return MimeMailExceptionCode.MESSAGING_ERROR.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (nextException instanceof BindException) {
                return MimeMailExceptionCode.BIND_ERROR.create(e, mailConfig == null ? STR_EMPTY : Integer.valueOf(mailConfig.getPort()));
            }
            if (nextException instanceof ConnectionException) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
            }
            if (nextException instanceof ConnectException) {
                MailServletInterface.mailInterfaceMonitor.changeNumTimeoutConnections(true);
                OXException me = MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
                return me;
            }
            if (nextException.getClass().getName().endsWith(EXC_CONNECTION_RESET_EXCEPTION)) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECTION_RESET.create(e, new Object[0]);
            }
            if (nextException instanceof NoRouteToHostException) {
                return MimeMailExceptionCode.NO_ROUTE_TO_HOST.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer());
            }
            if (nextException instanceof PortUnreachableException) {
                return MimeMailExceptionCode.PORT_UNREACHABLE.create(e, mailConfig == null ? STR_EMPTY : Integer.valueOf(mailConfig.getPort()));
            }
            if (nextException instanceof SocketException) {
                SocketException se = (SocketException)nextException;
                if ("Socket closed".equals(se.getMessage()) || "Connection reset".equals(se.getMessage())) {
                    MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                    return MimeMailExceptionCode.BROKEN_CONNECTION.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer());
                }
                return MimeMailExceptionCode.SOCKET_ERROR.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (nextException instanceof UnknownHostException) {
                return MimeMailExceptionCode.UNKNOWN_HOST.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
            }
            if (nextException instanceof SocketTimeoutException) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
            }
            if (nextException instanceof QuotaExceededException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.QUOTA_EXCEEDED_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                }
                return MimeMailExceptionCode.QUOTA_EXCEEDED.create(nextException, MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
            }
            if (nextException instanceof CommandFailedException) {
                String msg = Strings.toLowerCase((CharSequence)nextException.getMessage());
                if (MimeMailException.isInUseException(msg)) {
                    if (null != mailConfig && null != session) {
                        return MimeMailExceptionCode.IN_USE_ERROR_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                    }
                    return MimeMailExceptionCode.IN_USE_ERROR.create(nextException, MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                }
                if (MimeMailException.isOverQuotaException(msg)) {
                    if (null != mailConfig && null != session) {
                        return MimeMailExceptionCode.QUOTA_EXCEEDED_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                    }
                    return MimeMailExceptionCode.QUOTA_EXCEEDED.create(nextException, MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                }
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_WE_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
                }
                return MimeMailExceptionCode.PROCESSING_ERROR_WE.create(nextException, MimeMailException.appendInfo(MimeMailException.getInfo(MimeMailException.skipTag(nextException.getMessage())), folder));
            }
            if (nextException instanceof BadCommandException) {
                Category category = MimeMailExceptionCode.PROCESSING_ERROR.getCategory();
                if (Strings.toLowerCase((CharSequence)e.getMessage()).indexOf("[inuse]") >= 0) {
                    category = CATEGORY_USER_INPUT;
                }
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(nextException.getMessage(), folder)).setCategory(category);
                }
                return MimeMailExceptionCode.PROCESSING_ERROR.create(nextException, MimeMailException.appendInfo(nextException.getMessage(), folder)).setCategory(category);
            }
            if (nextException instanceof ProtocolException) {
                Category category = MimeMailExceptionCode.PROCESSING_ERROR.getCategory();
                if (Strings.toLowerCase((CharSequence)e.getMessage()).indexOf("[inuse]") >= 0) {
                    category = CATEGORY_USER_INPUT;
                }
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_EXT.create(nextException, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.appendInfo(nextException.getMessage(), folder)).setCategory(category);
                }
                return MimeMailExceptionCode.PROCESSING_ERROR.create(nextException, MimeMailException.appendInfo(nextException.getMessage(), folder)).setCategory(category);
            }
            if (nextException instanceof IOException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.IO_ERROR_EXT.create(nextException, MimeMailException.appendInfo(nextException.getMessage(), folder), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.IO_ERROR.create(nextException, MimeMailException.appendInfo(nextException.getMessage(), folder));
            }
            if (MimeMailException.toLowerCase(e.getMessage(), STR_EMPTY).indexOf(ERR_QUOTA) != -1) {
                return MimeMailExceptionCode.QUOTA_EXCEEDED.create(e, MimeMailException.getInfo(MimeMailException.skipTag(e.getMessage())));
            }
            return MimeMailExceptionCode.MESSAGING_ERROR.create(nextException, MimeMailException.appendInfo(nextException.getMessage(), folder));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            LOG.warn(STR_EMPTY, t);
            return MimeMailExceptionCode.MESSAGING_ERROR.create(e, MimeMailException.appendInfo(e.getMessage(), folder));
        }
    }

    public static String appendInfo(String info, Folder folder) {
        if (null == folder) {
            return info;
        }
        StringBuilder sb = null == info ? new StringBuilder(64) : new StringBuilder(info);
        sb.append(" (folder=\"").append(folder.getFullName()).append('\"');
        Store store = folder.getStore();
        if (null != store) {
            sb.append(", store=\"").append(store.toString()).append('\"');
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getInfo(String info) {
        if (null == info) {
            return info;
        }
        int pos = Strings.toLowerCase((CharSequence)info).indexOf("error message: ");
        return pos < 0 ? info : info.substring(pos + 15);
    }

    private static String skipTag(String serverResponse) {
        if (null == serverResponse) {
            return null;
        }
        Matcher m = PATTERN_TAG.matcher(serverResponse);
        if (m.matches()) {
            return m.group(1);
        }
        return serverResponse;
    }

    private static <E> E lookupNested(MessagingException e, Class<E> clazz) {
        if (null == e) {
            return null;
        }
        Exception exception = e.getNextException();
        if (clazz.isInstance(exception)) {
            return clazz.cast(exception);
        }
        return exception instanceof MessagingException ? (E)MimeMailException.lookupNested((MessagingException)((Object)exception), clazz) : null;
    }

    public static boolean isAlreadyExistsException(MessagingException e) {
        if (null == e) {
            return false;
        }
        return MimeMailException.isAlreadyExistsException(e.getMessage());
    }

    public static boolean isAlreadyExistsException(String msg) {
        if (null == msg) {
            return false;
        }
        String m = Strings.toLowerCase((CharSequence)msg);
        return m.indexOf("alreadyexists") >= 0;
    }

    public static boolean isOverQuotaException(MessagingException e) {
        if (null == e) {
            return false;
        }
        return MimeMailException.isOverQuotaException(e.getMessage());
    }

    public static boolean isOverQuotaException(String msg) {
        if (null == msg) {
            return false;
        }
        String m = Strings.toLowerCase((CharSequence)msg);
        return m.indexOf(ERR_QUOTA) >= 0 || m.indexOf("limit") >= 0;
    }

    public static boolean isInUseException(MessagingException e) {
        if (null == e) {
            return false;
        }
        return MimeMailException.isInUseException(Strings.toLowerCase((CharSequence)e.getMessage()));
    }

    public static boolean isInUseException(String msg) {
        if (null == msg) {
            return false;
        }
        return Strings.toLowerCase((CharSequence)msg).indexOf("[inuse]") >= 0;
    }

    public static boolean isCommandFailedException(MessagingException e) {
        if (null == e) {
            return false;
        }
        CommandFailedException commandFailedError = MimeMailException.lookupNested(e, CommandFailedException.class);
        return null != commandFailedError;
    }

    private static SmtpInfo getSmtpInfo(SMTPSendFailedException sendFailedError) {
        if (null == sendFailedError) {
            return null;
        }
        int retCode = sendFailedError.getReturnCode();
        if (retCode >= 400 && retCode <= 499 || retCode >= 500 && retCode <= 599) {
            return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
        }
        SmtpInfo smtpInfo = MimeMailException.optSmtpInfo(sendFailedError.getNextException());
        if (null != smtpInfo) {
            return smtpInfo;
        }
        return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
    }

    private static SmtpInfo getSmtpInfo(SMTPAddressFailedException sendFailedError) {
        if (null == sendFailedError) {
            return null;
        }
        int retCode = sendFailedError.getReturnCode();
        if (retCode >= 400 && retCode <= 499 || retCode >= 500 && retCode <= 599) {
            return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
        }
        SmtpInfo smtpInfo = MimeMailException.optSmtpInfo(sendFailedError.getNextException());
        if (null != smtpInfo) {
            return smtpInfo;
        }
        return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
    }

    private static SmtpInfo getSmtpInfo(SMTPSenderFailedException sendFailedError) {
        if (null == sendFailedError) {
            return null;
        }
        int retCode = sendFailedError.getReturnCode();
        if (retCode >= 400 && retCode <= 499 || retCode >= 500 && retCode <= 599) {
            return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
        }
        SmtpInfo smtpInfo = MimeMailException.optSmtpInfo(sendFailedError.getNextException());
        if (null != smtpInfo) {
            return smtpInfo;
        }
        return new SmtpInfo(sendFailedError.getReturnCode(), sendFailedError.getMessage());
    }

    private static SmtpInfo optSmtpInfo(Exception possibleSmtpException) {
        if (null == possibleSmtpException) {
            return null;
        }
        if (possibleSmtpException instanceof SMTPSendFailedException) {
            return MimeMailException.getSmtpInfo((SMTPSendFailedException)possibleSmtpException);
        }
        if (possibleSmtpException instanceof SMTPAddressFailedException) {
            return MimeMailException.getSmtpInfo((SMTPAddressFailedException)possibleSmtpException);
        }
        if (possibleSmtpException instanceof SMTPSenderFailedException) {
            return MimeMailException.getSmtpInfo((SMTPSenderFailedException)possibleSmtpException);
        }
        return null;
    }

    private static String toLowerCase(CharSequence chars, String defaultValue) {
        if (null == chars) {
            return defaultValue;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static final class SmtpInfo {
        final int retCode;
        final String message;

        SmtpInfo(int retCode, String message) {
            this.retCode = retCode;
            this.message = message;
        }

        public String toString() {
            return new StringBuilder(64).append(this.retCode).append(" - ").append(this.message).toString();
        }
    }
}

