/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorageRegistry;
import com.openexchange.mail.attachment.storage.DownloadUri;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.attachment.storage.StoreOperation;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.parser.DefaultAttachmentHandler;
import com.openexchange.mail.json.parser.LinkedAttachment;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tx.TransactionException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishAttachmentHandler
extends DefaultAttachmentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PublishAttachmentHandler.class);
    private final MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
    private List<LinkedPublication> createdPublications;

    public PublishAttachmentHandler(Session session, TransportProvider transportProvider, String protocol, String hostName) throws OXException {
        super(session, transportProvider, protocol, hostName);
    }

    @Override
    protected List<LinkedAttachment> publishAttachments(ComposedMailMessage source, List<OXException> warnings) throws OXException {
        MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
        ArrayList<LinkedAttachment> links = new ArrayList<LinkedAttachment>(this.attachments.size());
        long now = System.currentTimeMillis();
        HashMap<String, Object> storeProps = new HashMap<String, Object>(8);
        storeProps.put("subject", source.getSubject());
        storeProps.put("date", new Date(now));
        storeProps.put("to", source.getTo());
        for (MailPart attachment : this.attachments) {
            LinkedPublication linkedPublication = this.publishAttachmentAndGetPath(storeProps, attachment, attachmentStorage);
            if (null != this.createdPublications) {
                this.createdPublications.add(linkedPublication);
            }
            links.add(linkedPublication);
        }
        return links;
    }

    private LinkedPublication publishAttachmentAndGetPath(Map<String, Object> storeProps, MailPart attachment, MailAttachmentStorage attachmentStorage) throws OXException, TransactionException, OXException {
        storeProps.put("externalLocale", TransportProperties.getInstance().getExternalRecipientsLocale());
        String attachmentId = attachmentStorage.storeAttachment(attachment, StoreOperation.PUBLISH_STORE, storeProps, this.session);
        DownloadUri downloadUri = attachmentStorage.getDownloadUri(attachmentId, this.session);
        return new LinkedPublication(this.protocol, this.hostName, attachment.getFileName(), downloadUri, attachmentId);
    }

    private static String saneProtocol(String protocol) {
        if (protocol.endsWith("://")) {
            return protocol;
        }
        return protocol + "://";
    }

    private static boolean forcedSecure(String hostName) {
        ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        return configurationService != null && configurationService.getBoolProperty(ServerConfig.Property.FORCE_HTTPS.getPropertyName(), false) && !Cookies.isLocalLan(hostName);
    }

    public void startTransaction() throws OXException {
        this.createdPublications = new ArrayList<LinkedPublication>();
    }

    public void commit() throws OXException {
    }

    public void rollback() throws OXException {
        if (null != this.createdPublications && 0 < this.createdPublications.size()) {
            for (LinkedPublication publication : this.createdPublications) {
                try {
                    this.attachmentStorage.discard(publication.getAttachmentID(), publication.getDownloadUri(), this.session);
                }
                catch (OXException e) {
                    LOG.error("Error while deleting stored attachment with ID \"{}\".", (Object)publication.getAttachmentID(), (Object)e);
                }
            }
        }
    }

    public void finish() throws OXException {
    }

    private static final class LinkedPublication
    implements LinkedAttachment {
        private final String protocol;
        private final String hostName;
        private final String name;
        private final DownloadUri downloadUri;
        private final String attachmentID;

        public LinkedPublication(String protocol, String hostname, String name, DownloadUri downloadUri, String attachmentID) {
            this.protocol = protocol;
            this.hostName = hostname;
            this.name = name;
            this.downloadUri = downloadUri;
            this.attachmentID = attachmentID;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLink(InternetAddress recipient) {
            if (this.downloadUri.getDownloadUri().startsWith("http")) {
                return this.downloadUri.getDownloadUri();
            }
            return (Strings.isEmpty((String)this.protocol) ? (PublishAttachmentHandler.forcedSecure(this.hostName) ? "https://" : "http://") : PublishAttachmentHandler.saneProtocol(this.protocol)) + this.hostName + this.downloadUri.getDownloadUri();
        }

        public String getAttachmentID() {
            return this.attachmentID;
        }

        public DownloadUri getDownloadUri() {
            return this.downloadUri;
        }
    }
}

