/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.quotachecker.MailUploadQuotaChecker;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.parser.IAttachmentHandler;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttachmentHandler
implements IAttachmentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAttachmentHandler.class);
    protected final List<MailPart> attachments = new ArrayList<MailPart>(4);
    protected final boolean doAction;
    protected final long uploadQuota;
    protected final long uploadQuotaPerFile;

    public AbstractAttachmentHandler(Session session) throws OXException {
        UserSettingMail usm = session instanceof ServerSession ? ((ServerSession)session).getUserSettingMail() : UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContextId());
        MailUploadQuotaChecker checker = new MailUploadQuotaChecker(usm);
        this.uploadQuota = checker.getQuotaMax();
        this.uploadQuotaPerFile = checker.getFileQuotaMax();
        this.doAction = this.uploadQuotaPerFile > 0L || this.uploadQuota > 0L;
    }
}

