/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.compose.CompositionSpaces;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAwareComposedMailMessage;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="new", description="Send/Save mail as MIME data block (RFC822) (added in SP5)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", optional=true, description="In case the mail should not be sent out, but saved in a specific folder, the \"folder\" parameter can be used. If the mail should be sent out to the recipient, the \"folder\" parameter must not be included and the mail is stored in the folder \"Sent Items\". Example \"folder=default.INBOX/Testfolder\""), @Parameter(name="flags", optional=true, description="In case the mail should be stored with status \"read\" (e.g. mail has been read already in the client inbox), the parameter \"flags\" has to be included. If no \"folder\" parameter is specified, this parameter must not be included. For infos about mail flags see Detailed mail data spec.")}, requestBody="The MIME Data Block.", responseDescription="Object ID of the newly created/moved mail.")
public final class NewAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(NewAction.class);
    private static final String FLAGS = MailJSONField.FLAGS.getKey();
    private static final String FROM = MailJSONField.FROM.getKey();
    private static final String UPLOAD_FORMFIELD_MAIL = "json_0";
    private final EnumSet<ComposeType> draftTypes = EnumSet.of(ComposeType.DRAFT, ComposeType.DRAFT_DELETE_ON_TRANSPORT, ComposeType.DRAFT_EDIT, ComposeType.DRAFT_NO_DELETE_ON_TRANSPORT);

    public NewAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        AJAXRequestData request = req.getRequest();
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        try {
            long maxFileSize;
            long maxSize;
            if (TransportProperties.getInstance().isPublishOnExceededQuota() && req.getSession().getUserPermissionBits().hasInfostore()) {
                maxSize = -1L;
                maxFileSize = -1L;
            } else {
                UserSettingMail usm = req.getSession().getUserSettingMail();
                maxFileSize = usm.getUploadQuotaPerFile();
                if (maxFileSize <= 0L) {
                    maxFileSize = -1L;
                }
                if ((maxSize = usm.getUploadQuota()) <= 0L) {
                    if (maxSize == 0L) {
                        maxSize = -1L;
                    } else {
                        long globalQuota;
                        LOG.debug("Upload quota is less than zero. Using global server property \"MAX_UPLOAD_SIZE\" instead.");
                        try {
                            globalQuota = ServerConfig.getLong(ServerConfig.Property.MAX_UPLOAD_SIZE);
                        }
                        catch (OXException e) {
                            LOG.error("", (Throwable)e);
                            globalQuota = 0L;
                        }
                        long l = maxSize = globalQuota <= 0L ? -1L : globalQuota;
                    }
                }
            }
            if (request.hasUploads(maxFileSize, maxSize) || request.getParameter(UPLOAD_FORMFIELD_MAIL) != null) {
                return this.performWithUploads(req, request, warnings);
            }
            return this.performWithoutUploads(req, warnings);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult performWithUploads(MailRequest req, AJAXRequestData request, List<OXException> warnings) throws OXException, JSONException {
        AJAXRequestResult result;
        int accountId;
        InternetAddress from;
        ServerSession session = req.getSession();
        String csid = req.getParameter("csid");
        UploadEvent uploadEvent = request.getUploadEvent();
        String msgIdentifier = null;
        UserSettingMail userSettingMail = null;
        String json0 = uploadEvent.getFormField(UPLOAD_FORMFIELD_MAIL);
        if (json0 == null || json0.trim().length() == 0) {
            throw MailExceptionCode.PROCESSING_ERROR.create(MailExceptionCode.MISSING_PARAM.create(UPLOAD_FORMFIELD_MAIL), new Object[0]);
        }
        JSONObject jMail = new JSONObject(json0);
        if (null == csid) {
            csid = jMail.optString("csid", null);
        }
        try {
            InternetAddress[] fromAddresses = MessageParser.parseAddressKey(FROM, jMail, true);
            from = null == fromAddresses || 0 == fromAddresses.length ? null : fromAddresses[0];
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        try {
            accountId = NewAction.resolveFrom2Account(session, from, true, true);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e) || MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
            accountId = 0;
        }
        boolean newMessageId = AJAXRequestDataTools.parseBoolParameter("new", request);
        MailServletInterface mailInterface = this.getMailInterface(req);
        if ((jMail.optInt(FLAGS, 0) & 4) > 0) {
            ComposeType sendType;
            ComposedMailMessage composedMail = MessageParser.parse4Draft(jMail, uploadEvent, session, accountId, csid, warnings);
            UserSettingMail usm = session.getUserSettingMail();
            usm.setNoSave(true);
            this.checkAndApplyLineWrapAfter(request, usm);
            composedMail.setMailSettings(usm);
            MailPath msgref = composedMail.getMsgref();
            ComposeType composeType = sendType = jMail.hasAndNotNull("sendtype") ? ComposeType.getType(jMail.getInt("sendtype")) : null;
            if (null != sendType) {
                composedMail.setSendType(sendType);
            }
            if (newMessageId) {
                composedMail.removeHeader("Message-ID");
                composedMail.removeMessageId();
            }
            if ((msgIdentifier = mailInterface.saveDraft(composedMail, false, accountId).toString()) == null) {
                throw MailExceptionCode.DRAFT_FAILED_UNKNOWN.create();
            }
            if (null != csid) {
                CompositionSpace space;
                if (null != msgref && ComposeType.DRAFT_EDIT.equals((Object)sendType) && !(space = CompositionSpace.getCompositionSpace(csid, session)).isMarkedAsReplyOrForward(msgref)) {
                    space.addCleanUp(msgref);
                }
                CompositionSpaces.applyCompositionSpace(csid, session, mailInterface.getMailAccess(), this.isDraftAction(sendType));
                CompositionSpaces.destroy(csid, (Session)session);
            }
            warnings.addAll(mailInterface.getWarnings());
        } else {
            String sCopy2Sent;
            String folder;
            ComposeType sendType;
            String protocol = request.isSecure() ? "https://" : "http://";
            ComposedMailMessage[] composedMails = MessageParser.parse4Transport(jMail, uploadEvent, session, accountId, protocol, request.getHostname(), csid, warnings);
            if (newMessageId) {
                for (ComposedMailMessage composedMail : composedMails) {
                    if (null == composedMail) continue;
                    composedMail.removeHeader("Message-ID");
                    composedMail.removeMessageId();
                }
            }
            ComposeType composeType = sendType = jMail.hasAndNotNull("sendtype") ? ComposeType.getType(jMail.getInt("sendtype")) : ComposeType.NEW;
            if (null != csid && (ComposeType.DRAFT.equals((Object)sendType) || ComposeType.DRAFT_DELETE_ON_TRANSPORT.equals((Object)sendType))) {
                for (ComposedMailMessage composedMail : composedMails) {
                    MailPath msgref = composedMail.getMsgref();
                    if (null == msgref) continue;
                    CompositionSpace space = CompositionSpace.getCompositionSpace(csid, session);
                    if (space.isMarkedAsReply(msgref)) {
                        sendType = ComposeType.REPLY;
                        continue;
                    }
                    if (!space.isMarkedAsForward(msgref)) continue;
                    sendType = ComposeType.FORWARD;
                }
            }
            if (null != (folder = req.getParameter("folder"))) {
                MailTransport mailTransport = MailTransport.getInstance(session, accountId);
                MailMessage mm = mailTransport.sendMailMessage(composedMails[0], sendType, new Address[]{MimeMessageUtility.POISON_ADDRESS});
                mailInterface.openFor(folder);
                if (null != csid) {
                    CompositionSpaces.applyCompositionSpace(csid, session, mailInterface.getMailAccess(), this.isDraftAction(sendType));
                    CompositionSpaces.destroy(csid, (Session)session);
                }
                String[] ids = mailInterface.appendMessages(folder, new MailMessage[]{mm}, false);
                msgIdentifier = ids[0];
                mailInterface.updateMessageFlags(folder, ids, 32, true);
                JSONObject responseObj = new JSONObject(2);
                responseObj.put("folder_id", (Object)folder);
                responseObj.put("id", (Object)ids[0]);
                AJAXRequestResult result2 = new AJAXRequestResult((Object)responseObj, "json");
                return result2;
            }
            if (!newMessageId && this.draftTypes.contains((Object)sendType)) {
                for (ComposedMailMessage cm : composedMails) {
                    if (null == cm) continue;
                    cm.removeHeader("Message-ID");
                    cm.removeMessageId();
                }
            }
            if (ComposeType.DRAFT.equals((Object)sendType)) {
                String sDeleteDraftOnTransport;
                String paramName = "deleteDraftOnTransport";
                if (jMail.hasAndNotNull("deleteDraftOnTransport")) {
                    Object object = jMail.opt("deleteDraftOnTransport");
                    if (null != object && AJAXRequestDataTools.parseBoolParameter(object.toString())) {
                        sendType = ComposeType.DRAFT_DELETE_ON_TRANSPORT;
                    }
                } else if (request.containsParameter("deleteDraftOnTransport") && null != (sDeleteDraftOnTransport = request.getParameter("deleteDraftOnTransport")) && AJAXRequestDataTools.parseBoolParameter(sDeleteDraftOnTransport)) {
                    sendType = ComposeType.DRAFT_DELETE_ON_TRANSPORT;
                }
            } else if (ComposeType.DRAFT.equals((Object)sendType)) {
                // empty if block
            }
            for (ComposedMailMessage cm : composedMails) {
                if (null == cm) continue;
                cm.setSendType(sendType);
            }
            UserSettingMail usm = session.getUserSettingMail();
            usm.setNoSave(true);
            String paramName = "copy2Sent";
            if (jMail.hasAndNotNull("copy2Sent")) {
                Object object = jMail.opt("copy2Sent");
                if (null != object) {
                    if (AJAXRequestDataTools.parseBoolParameter(object.toString())) {
                        usm.setNoCopyIntoStandardSentFolder(false);
                    } else if (Boolean.FALSE.equals(AJAXRequestDataTools.parseFalseBoolParameter(object.toString()))) {
                        usm.setNoCopyIntoStandardSentFolder(true);
                    }
                }
            } else if (request.containsParameter("copy2Sent") && null != (sCopy2Sent = request.getParameter("copy2Sent"))) {
                if (AJAXRequestDataTools.parseBoolParameter(sCopy2Sent)) {
                    usm.setNoCopyIntoStandardSentFolder(false);
                } else if (Boolean.FALSE.equals(AJAXRequestDataTools.parseFalseBoolParameter(sCopy2Sent))) {
                    usm.setNoCopyIntoStandardSentFolder(true);
                }
            }
            this.checkAndApplyLineWrapAfter(request, usm);
            for (ComposedMailMessage cm : composedMails) {
                if (null == cm) continue;
                cm.setMailSettings(usm);
            }
            userSettingMail = usm;
            HttpServletRequest servletRequest = request.optHttpServletRequest();
            String remoteAddress = null == servletRequest ? request.getRemoteAddress() : servletRequest.getRemoteAddr();
            msgIdentifier = mailInterface.sendMessage(composedMails[0], sendType, accountId, usm, new MtaStatusInfo(), remoteAddress);
            for (int i = 1; i < composedMails.length; ++i) {
                ComposedMailMessage cm;
                cm = composedMails[i];
                if (null == cm) continue;
                mailInterface.sendMessage(cm, sendType, accountId, usm, new MtaStatusInfo(), remoteAddress);
            }
            if (null != csid) {
                CompositionSpaces.applyCompositionSpace(csid, session, null, this.isDraftAction(sendType));
                CompositionSpaces.destroy(csid, (Session)session);
            }
            warnings.addAll(mailInterface.getWarnings());
            try {
                ServerUserSetting setting = ServerUserSetting.getInstance();
                if (setting.isContactCollectOnMailTransport(session.getContextId(), session.getUserId()).booleanValue()) {
                    NewAction.triggerContactCollector(session, composedMails[0]);
                }
            }
            catch (Exception e) {
                LOG.warn("Contact collector could not be triggered.", (Throwable)e);
            }
        }
        if (msgIdentifier == null) {
            if (null != userSettingMail && userSettingMail.isNoCopyIntoStandardSentFolder()) {
                result = new AJAXRequestResult(JSONObject.NULL, "json");
                result.addWarnings(warnings);
                return result;
            }
            if (warnings.isEmpty()) {
                throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
            }
            result = new AJAXRequestResult(JSONObject.NULL, "json");
            result.addWarnings(warnings);
            return result;
        }
        result = new AJAXRequestResult((Object)msgIdentifier, "string");
        result.addWarnings(warnings);
        return result;
    }

    private void checkAndApplyLineWrapAfter(AJAXRequestData request, UserSettingMail usm) throws OXException {
        String sLineWrapAfter;
        String paramName = "lineWrapAfter";
        if (request.containsParameter(paramName) && null != (sLineWrapAfter = request.getParameter(paramName))) {
            try {
                int lineWrapAfter = Integer.parseInt(sLineWrapAfter.trim());
                usm.setAutoLinebreak(lineWrapAfter <= 0 ? 0 : lineWrapAfter);
            }
            catch (NumberFormatException nfe) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(nfe, paramName, sLineWrapAfter);
            }
        }
    }

    private boolean isDraftAction(ComposeType sendType) {
        return ComposeType.DRAFT_EDIT.equals((Object)sendType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performWithoutUploads(MailRequest req, List<OXException> warnings) throws OXException, MessagingException, JSONException {
        JSONObject responseData;
        PutNewMailDataImpl data;
        String fromAddr;
        ServerSession session = req.getSession();
        boolean newMessageId = AJAXRequestDataTools.parseBoolParameter("new", req.getRequest());
        String folder = req.getParameter("folder");
        int i = req.optInt("flags");
        int flags = -9999 == i ? 0 : i;
        String tmp = req.getParameter("force");
        boolean force = null == tmp ? false : AJAXRequestDataTools.parseBoolParameter(tmp);
        QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(NewAction.getDefaultSendAddress(session), false);
        MimeMessage message = MimeMessageUtility.newMimeMessage((InputStream)Streams.newByteArrayInputStream((byte[])Charsets.toAsciiBytes((String)((String)req.getRequest().requireData()))), true);
        message.removeHeader("x-original-headers");
        if (newMessageId) {
            message.removeHeader("Message-ID");
        }
        if (NewAction.isEmpty(fromAddr = message.getHeader(MessageHeaders.HDR_FROM, null))) {
            QuotedInternetAddress fromAddress = defaultSendAddr;
            message.setFrom((Address)fromAddress);
            data = new PutNewMailDataImpl(MimeMessageConverter.convertMessage(message), fromAddress);
        } else {
            data = new PutNewMailDataImpl(MimeMessageConverter.convertMessage(message), new QuotedInternetAddress(fromAddr, true));
        }
        if (folder == null) {
            responseData = this.transportMessage(session, flags, force, data.getFromAddress(), data.getMail(), req.getRequest());
        } else {
            String[] ids;
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            try {
                ids = mailInterface.appendMessages(folder, new MailMessage[]{data.getMail()}, force);
                if (flags > 0) {
                    mailInterface.updateMessageFlags(folder, ids, flags, true);
                }
            }
            finally {
                mailInterface.close(true);
            }
            JSONObject responseObj = new JSONObject(3);
            responseObj.put("folder_id", (Object)folder);
            responseObj.put("id", (Object)ids[0]);
            responseData = responseObj;
        }
        AJAXRequestResult result = new AJAXRequestResult((Object)responseData, "json");
        result.addWarnings(warnings);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject transportMessage(ServerSession session, int flags, boolean force, InternetAddress from, MailMessage m, AJAXRequestData request) throws OXException, JSONException {
        int accId;
        try {
            accId = NewAction.resolveFrom2Account(session, from, true, !force);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                throw e;
            }
            if (!force && MailExceptionCode.INVALID_SENDER.equals(e)) {
                throw e;
            }
            LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
            accId = 0;
        }
        int accountId = accId;
        try (MailTransport transport = MailTransport.getInstance(session, accountId);){
            String sCopy2Sent;
            MailMessage sentMail;
            OXException oxError = null;
            try {
                sentMail = m instanceof MimeMailMessage ? transport.sendMailMessage(new ContentAwareComposedMailMessage(((MimeMailMessage)m).getMimeMessage(), (Session)session, null), ComposeType.NEW) : transport.sendRawMessage(m.getSourceBytes());
            }
            catch (OXException e) {
                if (!MimeMailExceptionCode.SEND_FAILED_EXT.equals(e) && !MimeMailExceptionCode.SEND_FAILED_MSG_ERROR.equals(e)) {
                    throw e;
                }
                MailMessage ma = (MailMessage)e.getArgument("sent_message");
                if (null == ma) {
                    throw e;
                }
                sentMail = ma;
                oxError = e;
            }
            UserSettingMail usm = session.getUserSettingMail();
            usm.setNoSave(true);
            String paramName = "copy2Sent";
            if (request.containsParameter(paramName) && null != (sCopy2Sent = request.getParameter(paramName))) {
                if (AJAXRequestDataTools.parseBoolParameter(sCopy2Sent)) {
                    usm.setNoCopyIntoStandardSentFolder(false);
                } else if (Boolean.FALSE.equals(AJAXRequestDataTools.parseFalseBoolParameter(sCopy2Sent))) {
                    usm.setNoCopyIntoStandardSentFolder(true);
                }
            }
            JSONObject responseData = null;
            if (!usm.isNoCopyIntoStandardSentFolder()) {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    String[] uidArr;
                    mailAccess = MailAccess.getInstance(session, accountId);
                    mailAccess.connect();
                    String sentFullname = MailFolderUtility.prepareMailFolderParam(mailAccess.getFolderStorage().getSentFolder()).getFullname();
                    try {
                        if (flags != -9999) {
                            sentMail.setFlags(flags);
                        }
                        uidArr = mailAccess.getMessageStorage().appendMessages(sentFullname, new MailMessage[]{sentMail});
                        if (0 == accountId) {
                            EventPool.getInstance().put(new PooledEvent(session.getContextId(), session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, sentFullname), true, true, true, session));
                        }
                        try {
                            MailMessageCache.getInstance().removeFolderMessages(accountId, sentFullname, session.getUserId(), session.getContext().getContextId());
                        }
                        catch (OXException e) {
                            LOG.error("", (Throwable)e);
                        }
                    }
                    catch (OXException e) {
                        if (e.getMessage().indexOf("quota") != -1) {
                            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
                    }
                    if (uidArr != null && uidArr[0] != null) {
                        mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
                    }
                    responseData = new JSONObject(2);
                    responseData.put("folder_id", (Object)MailFolderUtility.prepareFullname(0, sentFullname));
                    responseData.put("id", (Object)uidArr[0]);
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(true);
                    }
                }
            }
            if (null != oxError) {
                throw oxError;
            }
            JSONObject jSONObject = responseData;
            return jSONObject;
        }
    }

    private class PutNewMailDataImpl
    implements PutNewMailData {
        private final MailMessage mail;
        private final InternetAddress fromAddress;

        PutNewMailDataImpl(MailMessage mail, InternetAddress fromAddress) {
            this.mail = mail;
            this.fromAddress = fromAddress;
        }

        @Override
        public MailMessage getMail() {
            return this.mail;
        }

        @Override
        public InternetAddress getFromAddress() {
            return this.fromAddress;
        }
    }

    private static interface PutNewMailData {
        public InternetAddress getFromAddress();

        public MailMessage getMail();
    }
}

