/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(EditAction.class);

    public EditAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        AJAXRequestData request = req.getRequest();
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        try {
            InternetAddress from;
            long maxSize;
            ServerSession session = req.getSession();
            UserSettingMail usm = session.getUserSettingMail();
            long maxFileSize = usm.getUploadQuotaPerFile();
            if (maxFileSize <= 0L) {
                maxFileSize = -1L;
            }
            if ((maxSize = usm.getUploadQuota()) <= 0L) {
                maxSize = -1L;
            }
            if (!request.hasUploads(maxFileSize, maxSize)) {
                throw AjaxExceptionCodes.UNKNOWN_ACTION.create("edit");
            }
            String csid = req.getParameter("csid");
            UploadEvent uploadEvent = request.getUploadEvent();
            MailPath msgIdentifier = null;
            JSONObject jsonMailObj = new JSONObject(uploadEvent.getFormField("json_0"));
            if (null == csid) {
                csid = jsonMailObj.optString("csid", null);
            }
            try {
                from = MessageParser.getFromField(jsonMailObj)[0];
            }
            catch (AddressException e) {
                throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
            }
            int accountId = EditAction.resolveFrom2Account(session, from, false, true);
            MailServletInterface msi = this.getMailInterface(req);
            if (msi.getDraftsFolder(accountId) == null) {
                if (0 == accountId) {
                    throw MailExceptionCode.FOLDER_NOT_FOUND.create("Drafts");
                }
                LOG.warn("Mail account {} for user {} in context {} has no drafts folder. Saving draft to default account's draft folder.", new Object[]{accountId, session.getUserId(), session.getContextId()});
                accountId = 0;
            }
            if (!jsonMailObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) || (jsonMailObj.getInt(MailJSONField.FLAGS.getKey()) & 4) <= 0) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create("No new message on action=edit");
            }
            ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, uploadEvent, session, 0, csid, warnings);
            MailPath msgref = composedMail.getMsgref();
            msgIdentifier = msi.saveDraft(composedMail, false, accountId);
            if (null != csid && null != msgref) {
                CompositionSpace space = CompositionSpace.getCompositionSpace(csid, session);
                space.addCleanUp(msgref);
            }
            if (msgIdentifier == null) {
                throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
            }
            AJAXRequestResult result = new AJAXRequestResult((Object)msgIdentifier, "string");
            result.addWarnings(warnings);
            return result;
        }
        catch (OXException e) {
            String uid;
            Object[] args = e.getDisplayArgs();
            String string = uid = null == args || 0 == args.length ? null : args[0].toString();
            if (MailExceptionCode.MAIL_NOT_FOUND.equals(e) && "undefined".equalsIgnoreCase(uid)) {
                throw MailExceptionCode.PROCESSING_ERROR.create(e, new Object[0]);
            }
            throw e;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

