/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractArchiveMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

@Action(method=RequestMethod.PUT, name="archive_folder", description="Moves mails to archive folder from given folder using certain criteria", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="days", description="The days threshold to use."), @Parameter(name="folder", description="Object ID of the source folder.")}, responseDescription="A JSON true response.")
public final class ArchiveFolderAction
extends AbstractArchiveMailAction {
    public ArchiveFolderAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult performArchive(MailRequest req) throws OXException {
        String sDays = req.getRequest().getParameter("days");
        int days = Strings.isEmpty((String)sDays) ? MailProperties.getInstance().getDefaultArchiveDays() : Strings.parsePositiveInt((String)sDays.trim());
        try {
            ServerSession session = req.getSession();
            String folderId = req.checkParameter("folder");
            MailServletInterface mailInterface = this.getMailInterface(req);
            boolean useDefaultName = AJAXRequestDataTools.parseBoolParameter("useDefaultName", req.getRequest(), true);
            boolean createIfAbsent = AJAXRequestDataTools.parseBoolParameter("createIfAbsent", req.getRequest(), true);
            mailInterface.archiveMailFolder(days, folderId, session, useDefaultName, createIfAbsent);
            return new AJAXRequestResult((Object)Boolean.TRUE, "native");
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

