/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.config;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailReloadable
implements Reloadable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailReloadable.class);
    private static final MailReloadable INSTANCE = new MailReloadable();
    private static final String CONFIGFILE = "mail.properties";
    private static final String[] PROPERTIES = new String[]{"com.openexchange.mail.loginSource", "com.openexchange.mail.passwordSource", "com.openexchange.mail.mailServerSource", "com.openexchange.mail.masterPassword", "com.openexchange.mail.mailServer", "com.openexchange.mail.transportServer"};
    private final List<Reloadable> reloadables = new CopyOnWriteArrayList<Reloadable>();

    public static MailReloadable getInstance() {
        return INSTANCE;
    }

    private MailReloadable() {
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void reloadConfiguration(ConfigurationService configService) {
        try {
            CacheService cacheService;
            MailProperties mailProperties = MailProperties.getInstance();
            if (null != mailProperties) {
                mailProperties.resetProperties();
                mailProperties.loadProperties();
            }
            if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
                try {
                    Cache cache = cacheService.getCache("Capabilities");
                    cache.clear();
                }
                catch (Exception x) {}
            }
        }
        catch (OXException e) {
            LOGGER.warn("Failed to reload mail properties", (Throwable)e);
        }
        for (Reloadable reloadable : this.reloadables) {
            reloadable.reloadConfiguration(configService);
        }
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put(CONFIGFILE, PROPERTIES);
        return map;
    }
}

