/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.attachment;

import com.openexchange.java.util.UUIDs;
import com.openexchange.mail.attachment.AttachmentTokenConstants;
import com.openexchange.session.Session;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public final class AttachmentToken
implements AttachmentTokenConstants {
    private final String id;
    private final long ttlMillis;
    private final AtomicLong timeoutStamp;
    private int contextId;
    private int userId;
    private int accountId;
    private String mailId;
    private String attachmentId;
    private String folderPath;
    private String sessionId;
    private String clientIp;
    private String client;
    private String userAgent;
    private String jsessionId;
    private boolean oneTime;
    private boolean checkIp;

    public AttachmentToken(long ttlMillis) {
        if (ttlMillis <= 0L) {
            throw new IllegalArgumentException("ttlMillis must be positive.");
        }
        this.id = new StringBuilder(75).append(UUIDs.getUnformattedString((UUID)UUID.randomUUID())).append('.').append(UUIDs.getUnformattedString((UUID)UUID.randomUUID())).toString();
        this.ttlMillis = ttlMillis;
        this.timeoutStamp = new AtomicLong(System.currentTimeMillis() + ttlMillis);
    }

    public AttachmentToken setOneTime(boolean oneTime) {
        this.oneTime = oneTime;
        return this;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public boolean isCheckIp() {
        return this.checkIp;
    }

    public AttachmentToken setCheckIp(boolean checkIp) {
        this.checkIp = checkIp;
        return this;
    }

    public String getJSessionId() {
        return this.jsessionId;
    }

    public AttachmentToken setAccessInfo(int accountId, Session session) {
        this.accountId = accountId;
        this.jsessionId = (String)session.getParameter("JSESSIONID");
        this.contextId = session.getContextId();
        this.userId = session.getUserId();
        this.sessionId = session.getSessionID();
        this.clientIp = session.getLocalIp();
        this.client = session.getClient();
        this.userAgent = (String)session.getParameter("user-agent");
        return this;
    }

    public AttachmentToken setAttachmentInfo(String folderPath, String mailId, String attachmentId) {
        this.folderPath = folderPath;
        this.mailId = mailId;
        this.attachmentId = attachmentId;
        return this;
    }

    public AttachmentToken touch() {
        long cur;
        while (!this.timeoutStamp.compareAndSet(cur = this.timeoutStamp.get(), System.currentTimeMillis() + this.ttlMillis)) {
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.timeoutStamp.get();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClient() {
        return this.client;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getMailId() {
        return this.mailId;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public void setMailId(String mailId) {
        this.mailId = mailId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setJsessionId(String jsessionId) {
        this.jsessionId = jsessionId;
    }
}

