/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api.permittance;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.permittance.Permitter;
import com.openexchange.mail.api.permittance.PermitterKey;
import com.openexchange.mail.config.MailReloadable;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Permittance {
    private static volatile Integer accessPermits;
    private static final ConcurrentMap<PermitterKey, PermitterImpl> SYNCHRONIZER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int accessPermits() {
        Integer tmp = accessPermits;
        if (null != tmp) return tmp;
        Class<Permittance> clazz = Permittance.class;
        synchronized (Permittance.class) {
            tmp = accessPermits;
            if (null != tmp) return tmp;
            int defaultValue = 0;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            accessPermits = tmp = Integer.valueOf(service.getIntProperty("com.openexchange.mail.accessPermits", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private Permittance() {
    }

    public static PermitterImpl acquireFor(int accountId, Session session) {
        int permits = Permittance.accessPermits();
        return permits > 0 ? Permittance.acquireFor0(PermitterKey.keyFor(accountId, session), permits) : null;
    }

    public static PermitterImpl acquireFor(PermitterKey key) {
        int permits = Permittance.accessPermits();
        return permits > 0 ? Permittance.acquireFor0(key, permits) : null;
    }

    private static PermitterImpl acquireFor0(PermitterKey key, int permits) {
        PermitterImpl newSemaphore;
        PermitterImpl permitter = (PermitterImpl)SYNCHRONIZER.get(key);
        if (null == permitter && null == (permitter = SYNCHRONIZER.putIfAbsent(key, newSemaphore = new PermitterImpl(permits, key)))) {
            permitter = newSemaphore;
        }
        return permitter;
    }

    public static void release(Permitter permitter) {
        if (null != permitter) {
            Permittance.releaseFor(permitter.getKey());
        }
    }

    public static void releaseFor(PermitterKey key) {
        if (null != key) {
            SYNCHRONIZER.remove(key);
        }
    }

    static {
        MailReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                accessPermits = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
        SYNCHRONIZER = new ConcurrentHashMap<PermitterKey, PermitterImpl>(256, 0.9f, 1);
    }

    private static final class PermitterImpl
    implements Permitter {
        private int permits;
        private int waits;
        private final PermitterKey key;

        PermitterImpl(int permits, PermitterKey key) {
            this.permits = permits;
            this.key = key;
        }

        @Override
        public PermitterKey getKey() {
            return this.key;
        }

        @Override
        public synchronized void acquire() throws OXException {
            while (this.permits <= 0) {
                ++this.waits;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw MailExceptionCode.INTERRUPT_ERROR.create(e, e.getMessage());
                }
                finally {
                    --this.waits;
                }
            }
            --this.permits;
        }

        @Override
        public synchronized boolean release() {
            ++this.permits;
            this.notify();
            return this.waits <= 0;
        }

        @Override
        public synchronized int getWaits() {
            return this.waits;
        }
    }
}

