/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.exception.OXException;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.ImageMessageHandler;
import com.openexchange.mail.parser.handlers.MailPartHandler;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.text.TextFinder;
import com.openexchange.tools.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailMessageStorage
implements IMailMessageStorage {
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageStorage.class);
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};
    private static final SearchTerm<Integer> TERM_FLAG_SEEN = new FlagTerm(32, false);

    @Override
    public abstract String[] appendMessages(String var1, MailMessage[] var2) throws OXException;

    @Override
    public abstract String[] copyMessages(String var1, String var2, String[] var3, boolean var4) throws OXException;

    @Override
    public abstract void deleteMessages(String var1, String[] var2, boolean var3) throws OXException;

    @Override
    public MailMessage[] getAllMessages(String folder, IndexRange indexRange, MailSortField sortField, OrderDirection order, MailField[] fields) throws OXException {
        return this.searchMessages(folder, indexRange, sortField, order, null, fields);
    }

    @Override
    public MailPart getAttachment(String folder, String mailId, String sequenceId) throws OXException {
        MailMessage mail = this.getMessage(folder, mailId, false);
        if (null == mail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(mailId, folder);
        }
        MailPartHandler handler = new MailPartHandler(sequenceId);
        new MailMessageParser().parseMailMessage(mail, handler);
        MailPart ret = handler.getMailPart();
        if (ret == null) {
            throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(sequenceId, mailId, folder);
        }
        return ret;
    }

    @Override
    public MailPart getImageAttachment(String folder, String mailId, String contentId) throws OXException {
        MailMessage mail = this.getMessage(folder, mailId, false);
        if (null == mail) {
            throw MailExceptionCode.MAIL_NOT_FOUND.create(mailId, folder);
        }
        ImageMessageHandler handler = new ImageMessageHandler(contentId);
        new MailMessageParser().parseMailMessage(mail, handler);
        MailPart ret = handler.getImagePart();
        if (ret == null) {
            throw MailExceptionCode.IMAGE_ATTACHMENT_NOT_FOUND.create(contentId, mailId, folder);
        }
        return ret;
    }

    @Override
    public String[] getPrimaryContents(String folder, String[] mailIds) throws OXException {
        TextFinder textFinder = new TextFinder();
        int length = mailIds.length;
        String[] retval = new String[length];
        for (int i = 0; i < length; ++i) {
            String text = null;
            try {
                text = textFinder.getText(this.getMessage(folder, mailIds[i], false));
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                LOG.warn("Error while getting primary content for mail ''{}'' in folder ''{}''. Returning null.", new Object[]{mailIds[i], folder, t});
            }
            retval[i] = text;
        }
        return retval;
    }

    @Override
    public MailMessage getMessage(String folder, String mailId, boolean markSeen) throws OXException {
        MailMessage[] mails = this.getMessages(folder, new String[]{mailId}, FIELDS_FULL);
        if (mails == null || mails.length == 0 || mails[0] == null) {
            return null;
        }
        MailMessage mail = mails[0];
        if (!mail.isSeen() && markSeen) {
            mail.setPrevSeen(false);
            this.updateMessageFlags(folder, new String[]{mailId}, 32, true);
            mail.setFlag(32, true);
            mail.setUnreadMessages(mail.getUnreadMessages() <= 0 ? 0 : mail.getUnreadMessages() - 1);
        }
        return mail;
    }

    @Override
    public abstract MailMessage[] getMessages(String var1, String[] var2, MailField[] var3) throws OXException;

    @Override
    public MailMessage[] getThreadSortedMessages(String folder, IndexRange indexRange, MailSortField sortField, OrderDirection order, SearchTerm<?> searchTerm, MailField[] fields) throws OXException {
        return null;
    }

    @Override
    public MailMessage[] getUnreadMessages(String folder, MailSortField sortField, OrderDirection order, MailField[] fields, int limit) throws OXException {
        if (limit == 0) {
            return EMPTY_RETVAL;
        }
        return this.searchMessages(folder, limit < 0 ? IndexRange.NULL : new IndexRange(0, limit), sortField, order, TERM_FLAG_SEEN, fields);
    }

    @Override
    public String[] moveMessages(String sourceFolder, String destFolder, String[] mailIds, boolean fast) throws OXException {
        String[] ids = this.copyMessages(sourceFolder, destFolder, mailIds, fast);
        this.deleteMessages(sourceFolder, mailIds, true);
        return ids;
    }

    @Override
    public abstract void releaseResources() throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailMessage saveDraft(String draftFullname, ComposedMailMessage draftMail) throws OXException {
        String uid;
        try {
            MailMessage filledMail = MimeMessageConverter.fillComposedMailMessage(draftMail);
            filledMail.setFlag(4, true);
            uid = this.appendMessages(draftFullname, new MailMessage[]{filledMail})[0];
        }
        finally {
            draftMail.cleanUp();
        }
        MailPath msgref = draftMail.getMsgref();
        if (msgref != null && draftFullname.equals(msgref.getFolder())) {
            this.deleteMessages(msgref.getFolder(), new String[]{msgref.getMailID()}, true);
            draftMail.setMsgref(null);
        }
        return this.getMessage(draftFullname, uid, true);
    }

    @Override
    public abstract MailMessage[] searchMessages(String var1, IndexRange var2, MailSortField var3, OrderDirection var4, SearchTerm<?> var5, MailField[] var6) throws OXException;

    @Override
    public void updateMessageColorLabel(String folder, String[] mailIds, int colorLabel) throws OXException {
    }

    @Override
    public void updateMessageUserFlags(String folder, String[] mailIds, String[] flags, boolean set) throws OXException {
    }

    @Override
    public abstract void updateMessageFlags(String var1, String[] var2, int var3, boolean var4) throws OXException;

    @Override
    public MailMessage[] getNewAndModifiedMessages(String folder, MailField[] fields) throws OXException {
        return EMPTY_RETVAL;
    }

    @Override
    public MailMessage[] getDeletedMessages(String folder, MailField[] fields) throws OXException {
        return EMPTY_RETVAL;
    }
}

