/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailAccessWatcher;
import com.openexchange.mail.MailcapInitialization;
import com.openexchange.mail.cache.EnqueueingMailAccessCache;
import com.openexchange.mail.cache.MailCacheConfiguration;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.cache.SingletonMailAccessCache;
import com.openexchange.mail.config.MailPropertiesInit;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.Initialization;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailInitialization
implements Initialization,
CacheAvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(MailInitialization.class);
    private static final MailInitialization INSTANCE = new MailInitialization();
    private final AtomicBoolean started = new AtomicBoolean();

    private MailInitialization() {
    }

    public static MailInitialization getInstance() {
        return INSTANCE;
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        Stack<Initialization> startedStack = new Stack<Initialization>();
        try {
            this.startUp(MailPropertiesInit.getInstance(), startedStack);
            this.startUp(MailCacheConfiguration.getInstance(), startedStack);
            this.startUp(new Initialization(){

                public void start() throws OXException {
                    MailAccessWatcher.init();
                }

                public void stop() {
                    MailAccessWatcher.stop();
                }
            }, startedStack);
            this.startUp(new Initialization(){

                public void start() throws OXException {
                    EventPool.initInstance();
                }

                public void stop() {
                    EventPool.releaseInstance();
                }
            }, startedStack);
            this.startUp(new Initialization(){

                public void start() {
                    MailcapInitialization.getInstance().init();
                }

                public void stop() {
                }
            }, startedStack);
            UserSettingMailStorage.getInstance();
            CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
            if (null != reg) {
                reg.registerListener(this);
                reg.registerListener(UserSettingMailStorage.getInstance());
            }
        }
        catch (OXException e) {
            this.started.set(false);
            for (Initialization startedInit : startedStack) {
                try {
                    startedInit.stop();
                }
                catch (Exception e1) {
                    LOG.error("Initialization could not be revoked", (Throwable)e1);
                }
            }
            throw e;
        }
    }

    private void startUp(Initialization initialization, Stack<Initialization> startedStack) throws OXException {
        initialization.start();
        startedStack.push(initialization);
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn("Duplicate shut-down of mail module aborted.");
            return;
        }
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this);
            reg.unregisterListener(UserSettingMailStorage.getInstance());
        }
        EventPool.releaseInstance();
        MimeType2ExtMap.reset();
        EnqueueingMailAccessCache.releaseInstance();
        SingletonMailAccessCache.releaseInstance();
        MailMessageCache.releaseInstance();
        UserSettingMailStorage.releaseInstance();
        MailAccessWatcher.stop();
        MailCacheConfiguration.getInstance().stop();
        MailPropertiesInit.getInstance().stop();
    }

    public void shutDownCaches() throws OXException {
        MailMessageCache.getInstance().releaseCache();
        MailCacheConfiguration.getInstance().stop();
    }

    public void startUpCaches() throws OXException {
        MailCacheConfiguration.getInstance().start();
        MailMessageCache.getInstance().initCache();
    }

    @Override
    public void handleAbsence() throws OXException {
        this.shutDownCaches();
    }

    @Override
    public void handleAvailability() throws OXException {
        this.startUpCaches();
    }

    public boolean isInitialized() {
        return this.started.get();
    }
}

