/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal.format;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.format.LoginFormatter;
import com.openexchange.session.Session;

public enum TokenFormatter implements LoginFormatter
{
    LOGIN("login", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            sb.append("Login:");
            sb.append(Strings.abbreviate((String)request.getLogin(), (int)256));
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    IP("ip", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            sb.append("IP:");
            sb.append(request.getClientIP());
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    AUTH_ID("auth", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            sb.append("AuthID:");
            sb.append(Strings.sanitizeString((String)request.getAuthId()));
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    AGENT("agent", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            sb.append("Agent:");
            sb.append(Strings.sanitizeString((String)request.getUserAgent()));
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    CLIENT("client", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            sb.append(" Client:");
            sb.append(Strings.sanitizeString((String)request.getClient()));
            sb.append('(');
            sb.append(Strings.sanitizeString((String)request.getVersion()));
            sb.append(')');
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    INTERFACE("iface", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            Interface iface = request.getInterface();
            if (null != iface) {
                sb.append("Interface:");
                sb.append(iface.toString());
            }
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
        }
    }),
    CONTEXT("c", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            this.formatLogout(result, sb);
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
            Context ctx = result.getContext();
            if (null != ctx) {
                sb.append(" Context:");
                sb.append(ctx.getContextId());
                sb.append('(');
                sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
                sb.append(')');
            }
        }
    }),
    USER("u", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            this.formatLogout(result, sb);
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
            User user = result.getUser();
            if (null != user) {
                sb.append(" User:");
                sb.append(user.getId());
                sb.append('(');
                sb.append(user.getLoginInfo());
                sb.append(')');
            }
        }
    }),
    SESSION("s", new LoginFormatter(){

        @Override
        public void formatLogin(LoginRequest request, LoginResult result, StringBuilder sb) {
            Session session = result.getSession();
            if (null == session) {
                sb.append(" No session created.");
            } else {
                sb.append(" Session:");
                sb.append(session.getSessionID());
                sb.append(" Random:");
                sb.append(session.getRandomToken());
                sb.append(" Transient:");
                sb.append(session.isTransient());
            }
        }

        @Override
        public void formatLogout(LoginResult result, StringBuilder sb) {
            Session session = result.getSession();
            if (null != session) {
                sb.append(" Session:");
                sb.append(session.getSessionID());
            }
        }
    });

    private final String token;
    private final LoginFormatter formatter;

    private TokenFormatter(String token, LoginFormatter formatter) {
        this.token = token;
        this.formatter = formatter;
    }

    @Override
    public void formatLogin(LoginRequest request, LoginResult result, StringBuilder logBuilder) {
        this.formatter.formatLogin(request, result, logBuilder);
    }

    @Override
    public void formatLogout(LoginResult result, StringBuilder logBuilder) {
        this.formatter.formatLogout(result, logBuilder);
    }

    public static TokenFormatter tokenFormatterFor(String token) {
        if (Strings.isEmpty((String)token)) {
            return null;
        }
        for (TokenFormatter tf : TokenFormatter.values()) {
            if (!tf.token.equals(token)) continue;
            return tf;
        }
        return null;
    }
}

