/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.guest;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum GuestExceptionCodes implements DisplayableOXExceptionCode
{
    DB_ERROR("Unexpected database error: \"%1$s\"", "Error while reading/writing data from/to the database.", Category.CATEGORY_WARNING, 1),
    NO_CONNECTION("Could not connect to guest storage.", Category.CATEGORY_SERVICE_DOWN, 2),
    NO_CONNECTION_PROVIDED("No connection provided to connect to guest storage.", Category.CATEGORY_ERROR, 3),
    SQL_ERROR("SQL problem: %1$s.", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 4),
    INVALID_EMAIL_ADDRESS("The provided mail address %1$s is invalid! It cannot be added to guest administration.", "The provided mail address %1$s is invalid! It cannot be added to guest administration.", Category.CATEGORY_USER_INPUT, 5),
    EMTPY_EMAIL_ADDRESS("The provided mail address is empty! It cannot be added to guest administration.", "The provided mail address is empty! It cannot be added to guest administration.", Category.CATEGORY_USER_INPUT, 6),
    GUEST_CREATION_ERROR("The guest cannot be created due to an internal server error.", Category.CATEGORY_ERROR, 7),
    GUEST_UPDATE_ERROR("Guest contact/user that should update all related contacts/users in different contexts is null. Cannot update related guests.", Category.CATEGORY_ERROR, 8),
    PASSWORD_RESET_ERROR("Error while resetting password for user with mail address: %1$s.", Category.CATEGORY_ERROR, 9),
    TOO_MANY_GUESTS_REMOVED("There have been %1$s guests removed but there should max be 1. Executed SQL: %2$s.", Category.CATEGORY_ERROR, 10),
    PASSWORD_EMPTY_ERROR("The new password to for guest with mail address %1$s is empty. Password update not possible!", "The new password might not be empty! Please provide a password.", Category.CATEGORY_USER_INPUT, 11),
    GUEST_WITHOUT_ASSIGNMENT_ERROR("No assignment for the guest with mail address %1$s found. This might indicate incosistences as there is a guest user without assignments. Guest id: %2$s.", Category.CATEGORY_ERROR, 12),
    CONTEXT_GUESTS_DELETION_ERROR("Inconsistences for deleting guest assignments: %1$s should be deleted but %2$s were deleted. Executed statement: %3$s", Category.CATEGORY_ERROR, 13);

    private static final String TOO_MANY_GUESTS_REMOVED_MSG = "There have been %1$s guests removed but there should max be 1. Executed SQL: %2$s.";
    private static final String PASSWORD_EMPTY_MSG = "The new password to for guest with mail address %1$s is empty. Password update not possible!";
    private static final String PASSWORD_RESET_ERROR_MSG = "Error while resetting password for user with mail address: %1$s.";
    private static final String NO_CONNECTION_TO_GUEST_STORAGE_MSG = "Could not connect to guest storage.";
    private static final String NO_CONNECTION_PROVIDED_TO_CONNECT_TO_GUEST_STORAGE_MSG = "No connection provided to connect to guest storage.";
    private static final String GUEST_CREATION_ERROR_MSG = "The guest cannot be created due to an internal server error.";
    private static final String GUEST_UPDATE_ERROR_MSG = "Guest contact/user that should update all related contacts/users in different contexts is null. Cannot update related guests.";
    private static final String GUEST_WITHOUT_ASSIGNMENT_MSG = "No assignment for the guest with mail address %1$s found. This might indicate incosistences as there is a guest user without assignments. Guest id: %2$s.";
    private static final String CONTEXT_GUESTS_DELETION_ERROR_MSG = "Inconsistences for deleting guest assignments: %1$s should be deleted but %2$s were deleted. Executed statement: %3$s";
    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;

    private GuestExceptionCodes(String message, Category category, int number) {
        this(message, null, category, number);
    }

    private GuestExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return "GUE";
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

