/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum UserConfigurationCodes implements DisplayableOXExceptionCode
{
    SQL_ERROR("A SQL error occurred: %1$s", null, Category.CATEGORY_ERROR, 1),
    DBPOOL_ERROR("A DBPooling error occurred", null, Category.CATEGORY_ERROR, 2),
    NOT_FOUND("Configuration for user %1$s could not be found in context %2$d", "Configuration for user %1$s could not be found in context %2$d.", Category.CATEGORY_ERROR, 3),
    MISSING_SETTING("Missing property %1$s in system.properties.", null, Category.CATEGORY_CONFIGURATION, 4),
    CLASS_NOT_FOUND("Class %1$s can not be found.", null, Category.CATEGORY_CONFIGURATION, 5),
    INSTANTIATION_FAILED("Instantiating the class failed.", null, Category.CATEGORY_ERROR, 6),
    CACHE_INITIALIZATION_FAILED("Cache initialization failed. Region: %1$s", null, Category.CATEGORY_ERROR, 7),
    CACHE_PUT_ERROR("User configuration could not be put into cache: %1$s", "User configuration could not be put into cache: \"%1$s\".", Category.CATEGORY_ERROR, 8),
    CACHE_CLEAR_ERROR("User configuration cache could not be cleared: %1$s", "User configuration cache could not be cleared: \"%1$s\".", Category.CATEGORY_ERROR, 9),
    CACHE_REMOVE_ERROR("User configuration could not be removed from cache: %1$s", "User configuration could not be removed from cache: \"%1$s\".", Category.CATEGORY_ERROR, 9),
    MAIL_SETTING_NOT_FOUND("Mail settings for user %1$s could not be found in context %2$d", "Mail settings for user \"%1$s\" could not be found in context %2$d.", Category.CATEGORY_ERROR, 10);

    private String message;
    private String displayMessage;
    private int detailNumber;
    private Category category;

    private UserConfigurationCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.detailNumber = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return "USS";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

