/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.UserClearDelTablesTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAddGuestCreatedByTask
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{UserClearDelTablesTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(UserAddGuestCreatedByTask.class);
        log.info("Performing update task {}", (Object)UserAddGuestCreatedByTask.class.getSimpleName());
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            Column guestCreatedByColumn = new Column("guestCreatedBy", "int(10) unsigned NOT NULL DEFAULT 0");
            Tools.checkAndAddColumns(connection, "user", guestCreatedByColumn);
            Tools.checkAndAddColumns(connection, "del_user", guestCreatedByColumn);
            if (null == Tools.existsIndex(connection, "user", new String[]{"cid", "guestCreatedBy"})) {
                Tools.createIndex(connection, "user", "guestCreatedByIndex", new String[]{"cid", "guestCreatedBy"}, false);
            }
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (!committed) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
        log.info("{} successfully performed.", (Object)UserAddGuestCreatedByTask.class.getSimpleName());
    }
}

