/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class ParticipantCommentFieldLength
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.ExtendCalendarForIMIPHandlingTask"};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            con.setAutoCommit(false);
            Tools.checkAndModifyColumns(con, "prg_dates_members", new Column("reason", "TEXT"));
            Tools.checkAndModifyColumns(con, "del_dates_members", new Column("reason", "TEXT"));
            Tools.checkAndModifyColumns(con, "dateExternal", new Column("reason", "TEXT"));
            Tools.checkAndModifyColumns(con, "delDateExternal", new Column("reason", "TEXT"));
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
    }
}

