/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.tasks.AbstractUserAliasTableUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.UUID;

public class MigrateUUIDsForUserAliasTable
extends AbstractUserAliasTableUpdateTask {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection connection = Database.getNoTimeout(contextId, true);
        try {
            Set<AbstractUserAliasTableUpdateTask.Alias> aliases;
            DBUtils.startTransaction(connection);
            if (!Tools.columnExists(connection, "user_alias", "uuid")) {
                Tools.addColumns(connection, "user_alias", new Column("uuid", "BINARY(16) DEFAULT NULL"));
            }
            if (!(aliases = this.getAllAliasesInUserAttributes(connection)).isEmpty()) {
                this.migrateUUIDs(connection, aliases);
            }
            this.insertUUIDs(connection);
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextId, true, connection);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUUIDs(Connection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatment = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT cid, user, alias FROM user_alias WHERE uuid IS NULL");
            preparedStatment = connection.prepareStatement("UPDATE user_alias SET uuid = ? WHERE cid = ? AND user = ? AND alias = ?");
            while (resultSet.next()) {
                this.addBatch(preparedStatment, resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3), UUIDs.toByteArray((UUID)UUID.randomUUID()));
            }
            preparedStatment.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(preparedStatment);
            throw throwable;
        }
        DBUtils.closeSQLStuff(preparedStatment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateUUIDs(Connection connection, Set<AbstractUserAliasTableUpdateTask.Alias> aliases) throws SQLException {
        PreparedStatement preparedStatment = null;
        try {
            preparedStatment = connection.prepareStatement("UPDATE user_alias SET uuid = ? WHERE cid = ? AND user = ? AND alias = ? AND uuid IS NULL");
            for (AbstractUserAliasTableUpdateTask.Alias alias : aliases) {
                this.addBatch(preparedStatment, alias.getCid(), alias.getUserId(), alias.getAlias(), UUIDs.toByteArray((UUID)alias.getUuid()));
            }
            preparedStatment.executeBatch();
        }
        finally {
            DBUtils.closeSQLStuff(preparedStatment);
        }
    }

    private void addBatch(PreparedStatement preparedStatement, int contextId, int userId, String alias, byte[] uuid) throws SQLException {
        int columnIndex = 0;
        preparedStatement.setBytes(++columnIndex, uuid);
        preparedStatement.setInt(++columnIndex, contextId);
        preparedStatement.setInt(++columnIndex, userId);
        preparedStatement.setString(++columnIndex, alias);
        preparedStatement.addBatch();
    }
}

