/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.AddUUIDForInfostoreReservedPaths;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MakeUUIDPrimaryForInfostoreReservedPaths
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        ProgressState progress = params.getProgressState();
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        try {
            DBUtils.startTransaction(connection);
            String table = "infostoreReservedPaths";
            String column = "uuid";
            progress.setTotal(this.getTotalRows("infostoreReservedPaths", connection));
            if (!Tools.columnExists(connection, "infostoreReservedPaths", "uuid")) {
                throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create("uuid", "infostoreReservedPaths");
            }
            AddUUIDForInfostoreReservedPaths.fillUUIDs(connection, "infostoreReservedPaths", progress);
            Tools.modifyColumns(connection, "infostoreReservedPaths", new Column("uuid", "BINARY(16) NOT NULL"));
            Tools.createPrimaryKeyIfAbsent(connection, "infostoreReservedPaths", new String[]{"cid", "uuid"});
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.AddUUIDForInfostoreReservedPaths"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalRows(String table, Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + table + " WHERE uuid IS NULL");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }
}

