/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.WorkingLevel;
import com.openexchange.groupware.update.tasks.FolderPermissionAddGuestGroup;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderPermissionReadAllForUserInfostore
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{FolderPermissionAddGuestGroup.class.getName()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING, WorkingLevel.SCHEMA);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(FolderPermissionReadAllForUserInfostore.class);
        log.info("Performing update task {}", (Object)FolderPermissionReadAllForUserInfostore.class.getSimpleName());
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            FolderPermissionReadAllForUserInfostore.adjustReadPermission(connection, 10, 4);
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (!committed) {
                DBUtils.rollback(connection);
            }
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
        log.info("{} successfully performed.", (Object)FolderPermissionReadAllForUserInfostore.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int adjustReadPermission(Connection connection, int folderID, int orp) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("UPDATE oxfolder_permissions SET orp=? WHERE fuid=?;");
            stmt.setInt(1, orp);
            stmt.setInt(2, folderID);
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

