/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderCorrectChangingDateTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(FolderCorrectChangingDateTask.class);
        log.info("Performing update task {}", (Object)FolderCorrectChangingDateTask.class.getSimpleName());
        PreparedStatement stmt = null;
        Connection connnection = Database.getNoTimeout(params.getContextId(), true);
        try {
            connnection.setAutoCommit(false);
            stmt = connnection.prepareStatement("UPDATE oxfolder_tree SET changing_date=? WHERE changing_date=?;");
            stmt.setLong(1, System.currentTimeMillis());
            stmt.setLong(2, Long.MAX_VALUE);
            int corrected = stmt.executeUpdate();
            log.info("Corrected {} rows in 'oxfolder_tree'.", (Object)corrected);
            connnection.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(connnection);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    DBUtils.rollback(connnection);
                    throw UpdateExceptionCodes.OTHER_PROBLEM.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                DBUtils.autocommit(connnection);
                Database.backNoTimeout(params.getContextId(), true, connnection);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        DBUtils.autocommit(connnection);
        Database.backNoTimeout(params.getContextId(), true, connnection);
        log.info("{} successfully performed.", (Object)FolderCorrectChangingDateTask.class.getSimpleName());
    }
}

