/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnlargeCalendarUid
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(EnlargeCalendarUid.class);
        log.info("Performing update task {}", (Object)EnlargeCalendarUid.class.getSimpleName());
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        try {
            con.setAutoCommit(false);
            for (String table : new String[]{"prg_dates", "del_dates"}) {
                Tools.checkAndModifyColumns(con, table, new Column("uid", "VARCHAR(1024)"));
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
        log.info("{} successfully performed.", (Object)EnlargeCalendarUid.class.getSimpleName());
    }
}

