/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateMissingPrimaryKeys
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    private void initTasks(final Connection con, List<Callable<Void>> tasks2) {
        class Splitter {
            private final Pattern split = Pattern.compile(" *, *");
            private final Pattern repl = Pattern.compile("[\\(\\)`]");

            Splitter() {
            }

            String[] split(String keys) {
                return this.split.split(this.repl.matcher(keys).replaceAll(""), 0);
            }
        }
        final Splitter splitter = new Splitter();
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "genconf_attributes_bools", splitter.split("(`cid`,`id`,`name`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE genconf_attributes_bools ADD PRIMARY KEY (`cid`,`id`,`name`), DROP KEY cid");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE genconf_attributes_bools ADD PRIMARY KEY (`cid`,`id`,`name`), DROP KEY cid";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "genconf_attributes_strings", splitter.split("(`cid`,`id`,`name`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE genconf_attributes_strings ADD PRIMARY KEY (`cid`,`id`,`name`), DROP KEY cid");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE genconf_attributes_strings ADD PRIMARY KEY (`cid`,`id`,`name`), DROP KEY cid";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "user_setting_server", splitter.split("(`cid`,`user`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE user_setting_server ADD PRIMARY KEY (`cid`,`user`), DROP KEY cid");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE user_setting_server ADD PRIMARY KEY (`cid`,`user`), DROP KEY cid";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "user_attribute", splitter.split("(`cid`,`id`,`name`,`value`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE user_attribute ADD PRIMARY KEY (`cid`,`id`,`name`,`value`(128)), DROP KEY cid_2");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE user_attribute ADD PRIMARY KEY (`cid`,`id`,`name`,`value`(128)), DROP KEY cid_2";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "ical_principal", splitter.split("(`cid`,`object_id`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE ical_principal ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal`(64))");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE ical_principal ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal`(64))";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "ical_ids", splitter.split("(`cid`,`object_id`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE ical_ids ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal_id`)");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE ical_ids ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal_id`)";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "vcard_principal", splitter.split("(`cid`,`object_id`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE vcard_principal ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal`(64))");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE vcard_principal ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal`(64))";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "vcard_ids", splitter.split("(`cid`,`object_id`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE vcard_ids ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal_id`)");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE vcard_ids ADD PRIMARY KEY (`cid`,`object_id`), ADD INDEX `indexPrincipal` (`cid`,`principal_id`)";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "infostoreReservedPaths", splitter.split("(`cid`,`folder`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE infostoreReservedPaths ADD PRIMARY KEY (`cid`,`folder`)");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE infostoreReservedPaths ADD PRIMARY KEY (`cid`,`folder`)";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "updateTask", splitter.split("(`cid`,`taskName`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE updateTask ADD PRIMARY KEY (`cid`,`taskName`(255)), DROP KEY full");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE updateTask ADD PRIMARY KEY (`cid`,`taskName`(255)), DROP KEY full";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "prg_links", splitter.split("(`cid`,`firstid`,`firstmodule`,`firstfolder`,`secondid`,`secondmodule`,`secondfolder`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE prg_links ADD PRIMARY KEY (`cid`,`firstid`,`firstmodule`,`firstfolder`,`secondid`,`secondmodule`,`secondfolder`)");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE prg_links ADD PRIMARY KEY (`cid`,`firstid`,`firstmodule`,`firstfolder`,`secondid`,`secondmodule`,`secondfolder`)";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                if (!Tools.existsPrimaryKey(con, "prg_contacts_linkage", splitter.split("(`cid`,`intfield01`,`intfield02`)"))) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE prg_contacts_linkage ADD PRIMARY KEY (`cid`,`intfield01`,`intfield02`)");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE prg_contacts_linkage ADD PRIMARY KEY (`cid`,`intfield01`,`intfield02`)";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                String name = Tools.existsIndex(con, "reminder", splitter.split("(`cid`,`target_id`)"));
                if (null != name) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE reminder DROP INDEX `" + name + "`");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE reminder DROP INDEX `cid`";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                String name = Tools.existsIndex(con, "virtualBackupPermission", splitter.split("(`cid`,`tree`,`user`,`folderId`)"));
                if (null != name) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE virtualBackupPermission DROP INDEX `" + name + "`");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE virtualBackupPermission DROP INDEX `cid`";
            }
        });
        tasks2.add(new Callable<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws SQLException {
                String name = Tools.existsIndex(con, "virtualPermission", splitter.split("(`cid`,`tree`,`user`,`folderId`)"));
                if (null != name) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("ALTER TABLE virtualPermission DROP INDEX `" + name + "`");
                    }
                    finally {
                        DBUtils.closeSQLStuff(stmt);
                    }
                }
                return null;
            }

            public String toString() {
                return "ALTER TABLE virtualPermission DROP INDEX `cid`";
            }
        });
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            DBUtils.startTransaction(con);
            LinkedList<Callable<Void>> tasks2 = new LinkedList<Callable<Void>>();
            this.initTasks(con, tasks2);
            Logger log = LoggerFactory.getLogger(CreateMissingPrimaryKeys.class);
            for (Callable callable : tasks2) {
                try {
                    callable.call();
                }
                catch (SQLException e) {
                    log.warn("ALTER TABLE failed with: >>{}<<\nStatement: >>{}<<", (Object)e.getMessage(), (Object)callable);
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }
}

