/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactFixUserDistListReferencesTask
extends UpdateTaskAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ContactFixUserDistListReferencesTask.class);

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = databaseService.getForUpdateTask(contextID);
        try {
            connection.setAutoCommit(false);
            LOG.info("Trying to auto-correct wrong contact references in 'prg_dlist'...");
            int corrected = this.correctWrongReferences(connection);
            LOG.info("Auto-corrected {} contact references.", (Object)corrected);
            LOG.info("Deleting remaining wrong contact references in 'prg_dlist'...");
            int deleted = this.deleteWrongReferences(connection);
            LOG.info("Deleted {} contact references.", (Object)deleted);
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(contextID, true, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int correctWrongReferences(Connection connection) throws SQLException {
        String sql = "UPDATE prg_dlist AS d LEFT JOIN prg_contacts AS c ON d.intfield02 = c.userid AND d.cid = c.cid SET d.intfield02 = c.intfield01 WHERE d.intfield03=1 AND d.field04 = c.field65 OR d.intfield03=2 AND d.field04 = c.field66 OR d.intfield03=3 AND d.field04 = c.field67;";
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteWrongReferences(Connection connection) throws SQLException {
        String sql = "UPDATE prg_dlist AS d LEFT JOIN prg_contacts AS c ON d.intfield02 = c.intfield01 AND d.cid = c.cid SET d.intfield02 = NULL, d.intfield03 = NULL, d.intfield04 = NULL WHERE d.intfield03=1 AND d.field04 <> c.field65 OR d.intfield03=2 AND d.field04 <> c.field66 OR d.intfield03=3 AND d.field04 <> c.field67;";
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            DBUtils.closeSQLStuff(statement);
        }
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }
}

