/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CalendarAddConfirmPerOccurrenceTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connnection = dbService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            connnection.setAutoCommit(false);
            rollback = true;
            Column occurrenceColumn = new Column("occurrence", "INT(10) unsigned NOT NULL DEFAULT '0'");
            Tools.checkAndAddColumns(connnection, "prg_dates_members", occurrenceColumn);
            Tools.checkAndAddColumns(connnection, "del_dates_members", occurrenceColumn);
            Tools.checkAndAddColumns(connnection, "dateExternal", occurrenceColumn);
            Tools.checkAndAddColumns(connnection, "delDateExternal", occurrenceColumn);
            connnection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connnection);
            }
            DBUtils.autocommit(connnection);
            Database.backNoTimeout(contextID, true, connnection);
        }
    }
}

