/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.UserAddGuestCreatedByTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddGuestCreatedByIndexForUserTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        Logger log = LoggerFactory.getLogger(AddGuestCreatedByIndexForUserTable.class);
        log.info("Performing update task {}", (Object)AddGuestCreatedByIndexForUserTable.class.getSimpleName());
        int ctxId = params.getContextId();
        Connection con = Database.getNoTimeout(ctxId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            if (null == Tools.existsIndex(con, "user", new String[]{"cid", "guestCreatedBy"})) {
                Tools.createIndex(con, "user", "guestCreatedByIndex", new String[]{"cid", "guestCreatedBy"}, false);
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
        log.info("{} successfully performed.", (Object)AddGuestCreatedByIndexForUserTable.class.getSimpleName());
    }

    @Override
    public String[] getDependencies() {
        return new String[]{UserAddGuestCreatedByTask.class.getName()};
    }
}

