/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public abstract class SimpleColumnCreationTask
extends UpdateTaskAdapter {
    private static final String ADD_COLUMN = "ALTER TABLE {0} ADD COLUMN {1}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            if (this.columnExists(con)) {
                return;
            }
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                stmt.execute(this.getStatement());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private String getStatement() {
        return MessageFormat.format(ADD_COLUMN, this.getTableName(), this.getColumnDefinition());
    }

    private boolean columnExists(Connection con) throws SQLException {
        return Tools.columnExists(con, this.getTableName(), this.getColumnName());
    }

    protected abstract String getTableName();

    protected abstract String getColumnName();

    protected abstract String getColumnDefinition();
}

