/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.tools.session.ServerSession;

public class TaskAuthorization
implements AttachmentAuthorization {
    @Override
    public void checkMayAttach(ServerSession session, int folderId, int taskId) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        FolderStorage foldStor = FolderStorage.getInstance();
        Task task = storage.selectTask(session.getContext(), taskId, StorageType.ACTIVE);
        task.setParentFolderID(folderId);
        FolderObject folder = Tools.getFolder(session.getContext(), folderId);
        Permission.checkWriteInFolder(session.getContext(), session.getUser(), session.getUserPermissionBits(), folder, task);
        foldStor.selectFolderById(session.getContext(), taskId, folderId, StorageType.ACTIVE);
    }

    @Override
    public void checkMayDetach(ServerSession session, int folderId, int taskId) throws OXException {
        this.checkMayAttach(session, folderId, taskId);
    }

    @Override
    public void checkMayReadAttachments(ServerSession session, int folderId, int taskId) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        FolderObject folder = Tools.getFolder(session.getContext(), folderId);
        Task task = storage.selectTask(session.getContext(), taskId, StorageType.ACTIVE);
        Permission.canReadInFolder(session.getContext(), session.getUser(), session.getUserPermissionBits(), folder, task);
    }
}

