/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="range", description="Get reminder range.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="end", description="The End date of the reminder range.")}, responseDescription="An Array with all reminders which are scheduled until the specified time. Each reminder is described in Reminder response.")
@OAuthAction(value="read_reminders")
public final class RangeAction
extends AbstractReminderAction {
    private static final Logger LOG = LoggerFactory.getLogger(RangeAction.class);

    public RangeAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        JSONArray jsonResponseArray;
        block16: {
            Date end = req.checkDate("end");
            TimeZone tz = req.getTimeZone();
            String timeZoneId = req.getParameter("timezone");
            TimeZone timeZone = null == timeZoneId ? tz : TimeZoneUtils.getTimeZone(timeZoneId);
            ReminderWriter reminderWriter = new ReminderWriter(timeZone);
            ServerSession session = req.getSession();
            ReminderHandler reminderSql = new ReminderHandler(session.getContext());
            User user = session.getUser();
            SearchIterator<ReminderObject> it = reminderSql.getArisingReminder(session, session.getContext(), user, end);
            jsonResponseArray = new JSONArray();
            block9: while (true) {
                while (it.hasNext()) {
                    ReminderObject reminder = (ReminderObject)it.next();
                    if (reminder.isRecurrenceAppointment()) {
                        try {
                            if (!this.getLatestRecurringReminder(session, tz, end, reminder)) {
                                ReminderObject nextReminder = RangeAction.getNextRecurringReminder(session, tz, reminder);
                                if (nextReminder != null) {
                                    reminderSql.updateReminder(nextReminder);
                                    continue block9;
                                }
                                reminderSql.deleteReminder(reminder);
                                continue;
                            }
                        }
                        catch (OXException e) {
                            if (e.isGeneric(OXException.Generic.NOT_FOUND)) {
                                LOG.warn("Cannot load target object of this reminder.", (Throwable)e);
                                RangeAction.deleteReminderSafe(reminder, user.getId(), reminderSql);
                            }
                            LOG.error("Can not calculate recurrence of appointment {}{}{}", new Object[]{reminder.getTargetId(), Character.valueOf(':'), session.getContextId(), e});
                        }
                    }
                    try {
                        if (!RangeAction.hasModulePermission(reminder, session) || !RangeAction.stillAccepted(reminder, session)) continue block9;
                        JSONObject jsonReminderObj = new JSONObject(12);
                        reminderWriter.writeObject(reminder, jsonReminderObj);
                        jsonResponseArray.put((Object)jsonReminderObj);
                        continue block9;
                    }
                    catch (OXException e) {
                        if (!OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                            throw e;
                        }
                        LOG.warn("Cannot load target object of this reminder.", (Throwable)e);
                        RangeAction.deleteReminderSafe(reminder, user.getId(), reminderSql);
                    }
                }
                break block16;
                {
                    continue block9;
                    break;
                }
                break;
            }
            finally {
                SearchIterators.close(it);
            }
        }
        return new AJAXRequestResult((Object)jsonResponseArray, "json");
    }
}

