/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.groupware.reminder.json.actions.DeleteAction;
import com.openexchange.groupware.reminder.json.actions.RangeAction;
import com.openexchange.groupware.reminder.json.actions.RemindAgainAction;
import com.openexchange.groupware.reminder.json.actions.UpdatesAction;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthModule;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="reminder", description="Provides the ability to fetch all active reminders for a user between two dates.")
@OAuthModule
public class ReminderActionFactory
implements AJAXActionServiceFactory {
    public static final String OAUTH_READ_SCOPE = "read_reminders";
    public static final String OAUTH_WRITE_SCOPE = "write_reminders";
    private final Map<String, AbstractReminderAction> actions = new ConcurrentHashMap<String, AbstractReminderAction>(4, 0.9f, 1);

    public ReminderActionFactory(ServiceLookup services) {
        this.actions.put("delete", new DeleteAction(services));
        this.actions.put("updates", new UpdatesAction(services));
        this.actions.put("range", new RangeAction(services));
        this.actions.put("remindAgain", new RemindAgainAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

