/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.ReminderStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class RdbReminderStorage
extends ReminderStorage {
    @Override
    public ReminderObject[] selectReminder(Context ctx, Connection con, User user, Date end) throws OXException {
        return this.selectReminder(ctx, con, user.getId(), end);
    }

    @Override
    public ReminderObject[] selectReminder(Context ctx, Connection con, int userId, Date end) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<ReminderObject> retval = new ArrayList<ReminderObject>();
        try {
            stmt = con.prepareStatement("SELECT object_id,target_id,module,userid,alarm,recurrence,description,folder,last_modified FROM reminder WHERE cid=? AND userid=? AND alarm<=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            stmt.setTimestamp(3, new Timestamp(end.getTime()));
            result = stmt.executeQuery();
            while (result.next()) {
                ReminderObject reminder = new ReminderObject();
                RdbReminderStorage.readResult(result, reminder);
                retval.add(reminder);
            }
        }
        catch (SQLException e) {
            try {
                throw ReminderExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval.toArray(new ReminderObject[retval.size()]);
    }

    @Override
    public void deleteReminder(Connection con, int ctxId, int reminderId) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM reminder WHERE cid=? AND object_id=?");
            int pos = 1;
            stmt.setInt(pos++, ctxId);
            stmt.setInt(pos++, reminderId);
            int deleted = stmt.executeUpdate();
            if (deleted == 0) {
                throw ReminderExceptionCode.NOT_FOUND.create(Autoboxing.I((int)reminderId), Autoboxing.I((int)ctxId));
            }
        }
        catch (SQLException exc) {
            throw ReminderExceptionCode.DELETE_EXCEPTION.create(exc, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private static void readResult(ResultSet result, ReminderObject reminder) throws SQLException {
        int pos = 1;
        reminder.setObjectId(result.getInt(pos++));
        reminder.setTargetId(result.getInt(pos++));
        reminder.setModule(result.getInt(pos++));
        reminder.setUser(result.getInt(pos++));
        reminder.setDate(result.getTimestamp(pos++));
        reminder.setRecurrenceAppointment(result.getBoolean(pos++));
        reminder.setDescription(result.getString(pos++));
        reminder.setFolder(result.getInt(pos++));
        reminder.setLastModified(new Date(result.getLong(pos++)));
    }

    @Override
    public void writeReminder(Connection con, int ctxId, ReminderObject reminder) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO reminder (object_id,cid,target_id,module,userid,alarm,recurrence,last_modified,folder) VALUES (?,?,?,?,?,?,?,?,?)");
            stmt.setInt(1, reminder.getObjectId());
            stmt.setInt(2, ctxId);
            stmt.setInt(3, reminder.getTargetId());
            stmt.setInt(4, reminder.getModule());
            stmt.setInt(5, reminder.getUser());
            stmt.setTimestamp(6, new Timestamp(reminder.getDate().getTime()));
            stmt.setInt(7, reminder.getRecurrencePosition());
            stmt.setLong(8, reminder.getLastModified().getTime());
            stmt.setInt(9, reminder.getFolder());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw ReminderExceptionCode.INSERT_EXCEPTION.create(e, new Object[0]);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

