/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import java.util.Locale;
import java.util.TimeZone;

public final class EmailableParticipant
implements Comparable<EmailableParticipant>,
Cloneable {
    public static final int STATE_NONE = 0;
    public static final int STATE_NEW = 1;
    public static final int STATE_REMOVED = -1;
    private int hc;
    public String email;
    public String displayName;
    private Locale locale;
    public int type;
    public int id;
    public int[] groups;
    public TimeZone timeZone;
    public int reliability;
    public int folderId;
    public int cid;
    public int confirm = 0;
    public String confirmMessage;
    public boolean ignoreNotification;
    public int state = 0;

    public EmailableParticipant(int cid, int type, int id, int[] groups, String email, String displayName, Locale locale, TimeZone timeZone, int reliability, int folderId, int confirm, String confirmMessage, boolean ignoreNotification) {
        this.cid = cid;
        this.type = type;
        this.email = email;
        this.displayName = displayName;
        this.locale = locale;
        this.id = id;
        this.groups = groups;
        this.timeZone = timeZone;
        this.reliability = reliability;
        this.folderId = folderId;
        this.hc = this.getHashCode();
        this.confirm = confirm;
        this.confirmMessage = confirmMessage;
        this.ignoreNotification = ignoreNotification;
    }

    private int getHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.email == null ? 0 : this.email.toLowerCase(Locale.ENGLISH).hashCode());
        return result;
    }

    public void copy(EmailableParticipant participant) {
        this.cid = participant.cid;
        this.type = participant.type;
        this.email = participant.email;
        this.displayName = participant.displayName;
        this.locale = participant.locale;
        this.id = participant.id;
        this.groups = participant.groups;
        this.timeZone = participant.timeZone;
        this.reliability = participant.reliability;
        this.state = participant.state;
        this.confirm = participant.confirm;
        this.confirmMessage = participant.confirmMessage;
        this.ignoreNotification = participant.ignoreNotification;
        this.hc = participant.hc;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object o) {
        if (o instanceof EmailableParticipant) {
            EmailableParticipant other = (EmailableParticipant)o;
            return other.email.equalsIgnoreCase(this.email);
        }
        return false;
    }

    @Override
    public int compareTo(EmailableParticipant other) {
        String myCompare = this.displayName == null ? this.email : this.displayName;
        String otherCompare = other.displayName == null ? other.email : other.displayName;
        int retval = myCompare != null && otherCompare != null ? myCompare.compareTo(otherCompare) : 0;
        return retval;
    }

    public Object clone() throws CloneNotSupportedException {
        EmailableParticipant clone = (EmailableParticipant)super.clone();
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        clone.timeZone = (TimeZone)(this.timeZone == null ? null : this.timeZone.clone());
        return clone;
    }

    public String toString() {
        return "EmailableParticipant" + " displayName=" + this.displayName + " email=" + this.email + " locale=" + this.locale + " timeZone=" + this.timeZone.getID();
    }

    public final Locale getLocale() {
        return this.locale;
    }
}

