/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import java.util.UUID;

public class AttributeValue {
    private final String value;
    private final UUID uuid;
    private String newValue;

    public AttributeValue(String value, UUID uuid, String newValue) {
        this.value = value;
        this.uuid = uuid;
        this.newValue = newValue;
    }

    public AttributeValue(String value, UUID uuid) {
        this(value, uuid, null);
    }

    public AttributeValue(String value) {
        this(value, null);
    }

    public AttributeValue(AttributeValue other, String newValue) {
        this(other.value, other.uuid, newValue);
    }

    public String getValue() {
        return this.value;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        if (null != this.newValue) {
            sb.append("=>").append(this.newValue);
        }
        sb.append('(').append(this.uuid).append(')');
        return sb.toString();
    }
}

