/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.search.ComparablePattern;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.SearchTermVisitor;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.Collection;

public final class NumberOfVersionsTerm
implements SearchTerm<ComparablePattern<Number>> {
    private final ComparablePattern<Number> pattern;

    public NumberOfVersionsTerm(ComparablePattern<Number> pattern) {
        this.pattern = pattern;
    }

    @Override
    public ComparablePattern<Number> getPattern() {
        return this.pattern;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<Metadata> col) {
        if (null != col) {
            col.add(Metadata.NUMBER_OF_VERSIONS_LITERAL);
        }
    }

    @Override
    public boolean matches(DocumentMetadata file) throws OXException {
        int numberOfVersions = file.getNumberOfVersions();
        switch (this.pattern.getComparisonType()) {
            case EQUALS: {
                return numberOfVersions == this.pattern.getPattern().intValue();
            }
            case LESS_THAN: {
                return numberOfVersions < this.pattern.getPattern().intValue();
            }
            case GREATER_THAN: {
                return numberOfVersions > this.pattern.getPattern().intValue();
            }
        }
        return false;
    }
}

