/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.SearchTermVisitor;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AndTerm
implements SearchTerm<List<SearchTerm<?>>> {
    private List<SearchTerm<?>> terms;

    public AndTerm(List<SearchTerm<?>> terms) {
        this.terms = null != terms ? terms : Collections.emptyList();
    }

    @Override
    public List<SearchTerm<?>> getPattern() {
        return this.terms;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<Metadata> col) {
        for (SearchTerm<?> term : this.terms) {
            term.addField(col);
        }
    }

    @Override
    public boolean matches(DocumentMetadata file) throws OXException {
        if (this.terms.isEmpty()) {
            return true;
        }
        boolean matches = this.terms.get(0).matches(file);
        for (int i = 1; matches && i < this.terms.size(); matches &= this.terms.get(i).matches(file), ++i) {
        }
        return matches;
    }
}

