/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.AbstractCreateTableImpl;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreFilenameReservationsCreateTableTask
extends AbstractCreateTableImpl
implements UpdateTaskV2 {
    private static final String INFOSTORE_RESERVED_PATHS = "infostoreReservedPaths";

    private String getTableSQL() {
        return "CREATE TABLE infostoreReservedPaths ( cid INT4 unsigned NOT NULL, folder INT4 unsigned NOT NULL,  name VARCHAR(767) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,  uuid BINARY(16) NOT NULL,  PRIMARY KEY (cid, uuid) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    protected String[] getCreateStatements() {
        return new String[]{this.getTableSQL()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        this.createTable(INFOSTORE_RESERVED_PATHS, this.getTableSQL(), contextId);
        Logger logger = LoggerFactory.getLogger(InfostoreFilenameReservationsCreateTableTask.class);
        logger.info("UpdateTask ''{}'' successfully performed!", (Object)InfostoreFilenameReservationsCreateTableTask.class.getSimpleName());
    }

    public String[] requiredTables() {
        return new String[0];
    }

    public String[] tablesToCreate() {
        return new String[]{INFOSTORE_RESERVED_PATHS};
    }

    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection writeCon = ds.getWritable(contextId);
        PreparedStatement stmt = null;
        try {
            if (this.tableExists(writeCon, tablename)) {
                return;
            }
            stmt = writeCon.prepareStatement(sqlCreate);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            ds.backWritable(contextId, writeCon);
        }
        ds.backWritable(contextId, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }
}

