/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractObjectPermissionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CreateObjectPermissionAction
extends AbstractObjectPermissionAction {
    private final DocumentMetadata document;

    public CreateObjectPermissionAction(DBProvider provider, Context context, DocumentMetadata document) {
        super(provider, context);
        this.document = document;
    }

    public void perform() throws OXException {
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        List<ObjectPermission> objectPermissions = this.document.getObjectPermissions();
        if (null != objectPermissions) {
            for (final ObjectPermission objectPermission : objectPermissions) {
                updates.add(new AbstractDBAction.Update("INSERT INTO object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, CreateObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, objectPermission.getEntity());
                        this.stmt.setInt(3, 8);
                        this.stmt.setInt(4, (int)CreateObjectPermissionAction.this.document.getFolderId());
                        this.stmt.setInt(5, CreateObjectPermissionAction.this.document.getId());
                        this.stmt.setInt(6, CreateObjectPermissionAction.this.document.getModifiedBy());
                        this.stmt.setInt(7, CreateObjectPermissionAction.this.document.getCreatedBy());
                        this.stmt.setInt(8, objectPermission.getPermissions());
                        this.stmt.setLong(9, CreateObjectPermissionAction.this.document.getLastModified().getTime());
                        this.stmt.setBoolean(10, objectPermission.isGroup());
                    }
                });
            }
        }
        this.doUpdates(updates);
    }

    protected void undoAction() throws OXException {
        this.doUpdates(new AbstractDBAction.Update("DELETE FROM object_permission WHERE cid=? AND object_id=?;"){

            @Override
            public void fillStatement() throws SQLException {
                this.stmt.setInt(1, CreateObjectPermissionAction.this.getContext().getContextId());
                this.stmt.setInt(2, CreateObjectPermissionAction.this.document.getId());
            }
        });
    }
}

