/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database;

import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.AbstractFileLocationHandler;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Reference;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class InfostoreFilestoreLocationUpdater
extends AbstractFileLocationHandler {
    @Override
    public void updateFileLocations(Map<String, String> prevFileName2newFileName, int contextId, Connection con) throws SQLException {
        String selectStmt = "SELECT file_store_location FROM infostore_document WHERE cid=? AND file_store_location IN ";
        String updateStmt = "UPDATE infostore_document SET file_store_location = ? WHERE cid = ? AND file_store_location = ?";
        InfostoreFilestoreLocationUpdater.updateFileLocationsUsing(prevFileName2newFileName, contextId, selectStmt, updateStmt, con);
    }

    @Override
    public Set<String> determineFileLocationsFor(int contextId, Connection con) throws OXException, SQLException {
        TIntObjectMap<TIntList> folders2 = this.fetchFolders(contextId, con);
        Context context = ContextStorage.getInstance().getContext(contextId);
        UserStorage userStorage = UserStorage.getInstance();
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        TIntObjectIterator it = folders2.iterator();
        while (it.hasNext()) {
            it.advance();
            User user = userStorage.getUser(it.key(), context);
            if (user.getFilestoreId() > 0) continue;
            locations.addAll(this.getFileLocationsFor((TIntList)it.value(), contextId, con));
        }
        return locations;
    }

    @Override
    public Set<String> determineFileLocationsFor(int userId, int contextId, Connection con) throws OXException, SQLException {
        TIntList folderIds = this.fetchFolders(userId, contextId, con);
        return this.getFileLocationsFor(folderIds, contextId, con);
    }

    private Set<String> getFileLocationsFor(TIntList folderIds, final int contextId, final Connection con) throws OXException, SQLException {
        final Reference error = new Reference();
        final LinkedHashSet<String> locations = new LinkedHashSet<String>();
        folderIds.forEach(new TIntProcedure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public boolean execute(int folderId) {
                boolean keepOn;
                block8: {
                    keepOn = false;
                    PreparedStatement stmt = null;
                    ResultSet rs = null;
                    try {
                        stmt = con.prepareStatement("SELECT d.file_store_location FROM infostore AS i JOIN infostore_document AS d ON i.cid=? AND d.cid=? AND i.id=d.infostore_id WHERE i.cid=? and folder_id=? AND d.file_store_location IS NOT NULL");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, contextId);
                        stmt.setInt(3, contextId);
                        stmt.setInt(4, folderId);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            locations.add(rs.getString(1));
                        }
                        keepOn = true;
                        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    }
                    catch (SQLException e) {
                        error.setValue((Object)e);
                    }
                    catch (RuntimeException e2) {
                        error.setValue((Object)e2);
                        break block8;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Databases.closeSQLStuff(rs, (Statement)stmt);
                    }
                }
                return keepOn;
            }
        });
        Exception exception = (Exception)error.getValue();
        if (null != exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw OXException.general((String)"", (Throwable)exception);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntObjectMap<TIntList> fetchFolders(int contextId, Connection con) throws SQLException {
        TIntObjectHashMap tIntObjectHashMap;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT created_from, fuid FROM oxfolder_tree WHERE cid=? AND module=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, 8);
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            TIntObjectHashMap tIntObjectHashMap2 = new TIntObjectHashMap(0);
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return tIntObjectHashMap2;
        }
        try {
            TIntObjectHashMap map = new TIntObjectHashMap(2048);
            do {
                int owner;
                TIntList folderIds;
                if (null == (folderIds = (TIntList)map.get(owner = rs.getInt(1)))) {
                    folderIds = new TIntLinkedList();
                    map.put(owner, (Object)folderIds);
                }
                int folderId = rs.getInt(2);
                folderIds.add(folderId);
            } while (rs.next());
            tIntObjectHashMap = map;
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return tIntObjectHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntList fetchFolders(int userId, int contextId, Connection con) throws SQLException {
        TIntLinkedList tIntLinkedList;
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=? AND created_from=? AND module=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            stmt.setInt(3, 8);
            rs = stmt.executeQuery();
            if (rs.next()) break block4;
            TIntLinkedList tIntLinkedList2 = new TIntLinkedList();
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return tIntLinkedList2;
        }
        try {
            TIntLinkedList folderIds = new TIntLinkedList();
            do {
                int folderId = rs.getInt(1);
                folderIds.add(folderId);
            } while (rs.next());
            tIntLinkedList = folderIds;
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return tIntLinkedList;
    }
}

