/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport.csv;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.csv.CsvExceptionCodes;
import com.openexchange.java.Autoboxing;
import java.util.LinkedList;
import java.util.List;

public class CSVParser {
    public static final char LINE_DELIMITER = '\n';
    public static final char CELL_DELIMITER = ',';
    public static final char ESCAPER = '\"';
    public static final int STARTING_LENGTH = -1;
    private boolean isEscaping;
    protected boolean isTolerant = false;
    private String file;
    private int numberOfCells;
    private int currentLineNumber;
    private StringBuilder currentCell = new StringBuilder();
    private List<String> currentLine = new LinkedList<String>();
    private List<List<String>> structure = new LinkedList<List<String>>();
    private int pointer;
    private char[] fileAsArray;
    private char cellDelimiter = (char)44;

    public CSVParser(String file) {
        this();
        this.file = file;
    }

    private void reset() {
        this.numberOfCells = -1;
        this.currentLineNumber = 0;
        this.currentCell = new StringBuilder();
        this.currentLine = new LinkedList<String>();
        this.structure = new LinkedList<List<String>>();
    }

    public CSVParser() {
        this.reset();
    }

    public boolean isTolerant() {
        return this.isTolerant;
    }

    public void setTolerant(boolean isTolerant) {
        this.isTolerant = isTolerant;
    }

    public void setCellDelimiter(char delimiter) {
        this.cellDelimiter = delimiter;
    }

    public List<List<String>> parse(String str) throws OXException {
        this.reset();
        this.file = str;
        return this.parse();
    }

    public List<List<String>> parse() throws OXException {
        if (this.file == null) {
            return null;
        }
        this.file = CSVParser.wellform(this.file);
        this.fileAsArray = this.file.toCharArray();
        this.pointer = 0;
        while (this.pointer < this.fileAsArray.length) {
            char c = this.fileAsArray[this.pointer];
            if (this.cellDelimiter == c) {
                this.handleCellDelimiter();
            } else if ('\n' == c) {
                this.handleLineDelimiter();
            } else if ('\"' == c) {
                this.handleEscaping();
            } else {
                this.handleDefault();
            }
            ++this.pointer;
        }
        if (this.currentCell.length() != 0 || !this.currentLine.isEmpty()) {
            throw CsvExceptionCodes.DATA_AFTER_LAST_LINE.create();
        }
        return this.structure;
    }

    protected void handleDefault() {
        this.currentCell.append(this.fileAsArray[this.pointer]);
    }

    protected void handleCellDelimiter() throws OXException {
        if (this.isEscaping) {
            this.currentCell.append(this.cellDelimiter);
        } else if (this.numberOfCells == -1 || this.numberOfCells != -1 && this.currentLine.size() <= this.numberOfCells) {
            this.currentLine.add(this.currentCell.toString().trim());
            this.currentCell = new StringBuilder();
        } else if (!this.isTolerant()) {
            throw CsvExceptionCodes.BROKEN_CSV.create(Autoboxing.I((int)this.numberOfCells), Autoboxing.I((int)this.currentLineNumber), Autoboxing.I((int)this.currentLine.size()));
        }
    }

    protected void handleEscaping() {
        if (this.isEscaping) {
            if (this.pointer + 1 < this.fileAsArray.length && this.fileAsArray[this.pointer + 1] == '\"') {
                this.currentCell.append('\"');
                ++this.pointer;
            } else {
                this.isEscaping = false;
            }
        } else {
            this.isEscaping = true;
        }
    }

    protected void handleLineDelimiter() throws OXException {
        if (this.isEscaping) {
            this.currentCell.append('\n');
        } else {
            ++this.currentLineNumber;
            if (this.currentLine.size() < this.numberOfCells || this.numberOfCells == -1) {
                this.currentLine.add(this.currentCell.toString().trim());
            } else if (!this.isTolerant()) {
                throw CsvExceptionCodes.BROKEN_CSV.create(Autoboxing.I((int)this.numberOfCells), Autoboxing.I((int)this.currentLineNumber), Autoboxing.I((int)this.currentLine.size()));
            }
            this.currentCell = new StringBuilder();
            if (this.numberOfCells == -1) {
                this.numberOfCells = this.currentLine.size();
                this.structure.add(this.currentLine);
            } else if (this.numberOfCells == this.currentLine.size() || this.isTolerant()) {
                for (int j = this.currentLine.size(); j < this.numberOfCells; ++j) {
                    this.currentLine.add("");
                }
                this.structure.add(this.currentLine);
            } else {
                throw CsvExceptionCodes.BROKEN_CSV.create(Autoboxing.I((int)this.numberOfCells), Autoboxing.I((int)this.currentLineNumber), Autoboxing.I((int)this.currentLine.size()));
            }
            this.currentLine = new LinkedList<String>();
        }
    }

    public void setFileContent(String content) {
        this.file = content;
    }

    public String getLine(int lineNumber) {
        this.file = CSVParser.wellform(this.file);
        return this.file.split("\n")[lineNumber];
    }

    protected static String wellform(String str) {
        String retval = str.replace("\r\n", "\n").replace("\r", "\n");
        if (!(retval = retval.trim()).endsWith("\n")) {
            retval = retval + "\n";
        }
        return retval;
    }
}

