/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Collators;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class CreatedByComparator
implements Comparator<DataObject> {
    private final TIntObjectMap<String> cache = new TIntObjectHashMap(24);
    private final Collator collator;
    private final Context context;
    private boolean desc;

    public CreatedByComparator(Locale locale, Context context) {
        this.collator = Collators.getSecondaryInstance((Locale)locale);
        this.context = context;
    }

    public CreatedByComparator setDescending(boolean desc) {
        this.desc = desc;
        return this;
    }

    @Override
    public int compare(DataObject o1, DataObject o2) {
        int result;
        int owner1 = o1.getCreatedBy();
        int owner2 = o2.getCreatedBy();
        if (owner1 > 0 && owner2 > 0) {
            result = this.collator.compare(this.getDisplayName(owner1), this.getDisplayName(owner2));
        } else {
            int n = owner1 < owner2 ? -1 : (result = owner1 == owner2 ? 0 : 1);
        }
        if (this.desc) {
            return result > 0 ? -1 : (result == 0 ? 0 : 1);
        }
        return result;
    }

    private String getDisplayName(int userId) {
        String displayName = (String)this.cache.get(userId);
        if (null == displayName) {
            try {
                displayName = UserStorage.getInstance().getUser(userId, this.context).getDisplayName();
            }
            catch (OXException e) {
                return null;
            }
            this.cache.put(userId, (Object)displayName);
        }
        return displayName;
    }
}

