/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.datasource;

import com.openexchange.contact.ContactService;
import com.openexchange.contact.internal.VCardUtil;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.DataSource;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ContactDataSource
implements DataSource {
    private static final Class<?>[] TYPES = new Class[]{InputStream.class, byte[].class};
    private static final String[] ARGS = new String[]{"com.openexchange.groupware.contact.pairs"};

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        Object object;
        int[] objectIds;
        int[] folderIds;
        int len;
        if (!InputStream.class.equals(type) && !byte[].class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        try {
            JSONArray pairsArray = new JSONArray(dataArguments.get(ARGS[0]));
            len = pairsArray.length();
            if (len == 0) {
                throw DataExceptionCodes.MISSING_ARGUMENT.create(new Object[]{ARGS[0]});
            }
            folderIds = new int[len];
            objectIds = new int[len];
            for (int i = 0; i < len; ++i) {
                JSONObject pairObject = pairsArray.getJSONObject(i);
                folderIds[i] = pairObject.getInt("folder");
                objectIds[i] = pairObject.getInt("id");
            }
        }
        catch (JSONException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create((Throwable)e, new Object[]{ARGS[0], dataArguments.get(ARGS[0])});
        }
        Contact[] contacts2 = new Contact[len];
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class, true);
        for (int i = 0; i < len; ++i) {
            contacts2[i] = contactService.getContact(session, Integer.toString(folderIds[i]), Integer.toString(objectIds[i]));
        }
        UnsynchronizedByteArrayOutputStream sink = new UnsynchronizedByteArrayOutputStream(len << 12);
        for (Contact contact : contacts2) {
            VCardUtil.exportContact(contact, session, (OutputStream)sink);
        }
        DataProperties properties = new DataProperties();
        properties.put("com.openexchange.conversion.charset", "UTF-8");
        properties.put("com.openexchange.conversion.version", "3.0");
        properties.put("com.openexchange.conversion.content-type", "text/vcard");
        String displayName = contacts2.length == 1 ? contacts2[0].getDisplayName() : null;
        properties.put("com.openexchange.conversion.name", displayName == null ? "vcard.vcf" : displayName.replaceAll(" +", "_") + ".vcf");
        byte[] vcardBytes = sink.toByteArray();
        properties.put("com.openexchange.conversion.size", String.valueOf(vcardBytes.length));
        if (InputStream.class.equals(type)) {
            UnsynchronizedByteArrayInputStream unsynchronizedByteArrayInputStream;
            object = unsynchronizedByteArrayInputStream;
            unsynchronizedByteArrayInputStream = new UnsynchronizedByteArrayInputStream(vcardBytes);
        } else {
            object = vcardBytes;
        }
        return new SimpleData(object, properties);
    }

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }
}

